package com.xebialabs.xlrelease.api.internal


import com.xebialabs.xlrelease.domain.environments.Environment
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository
import jakarta.ws.rs._
import jakarta.ws.rs.core.MediaType
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Path("/deployment-target")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait DeploymentTargetResource {

  @POST
  def getEnvironments(environmentIds: JList[String]): JList[Environment]

  @GET
  @Path("{environmentId:.+}")
  def getEnvironment(@PathParam("environmentId") environmentId: String): Environment

  @GET
  @Path("/folder/{folderId:.+}")
  def getEnvironmentsByFolderId(@PathParam("folderId") folderId: String): JList[Environment]
}

@Controller
class DeploymentTargetResourceImpl(environmentRepository: EnvironmentRepository) extends DeploymentTargetResource {

  override def getEnvironments(environmentIds: JList[String]): JList[Environment] = {
    environmentRepository.fetchEnvironments(environmentIds.asScala.toList).asJava
  }

  override def getEnvironment(environmentId: String): Environment = {
    environmentRepository.findEnvironmentById(environmentId)
  }

  override def getEnvironmentsByFolderId(folderId: String): JList[Environment] = {
    environmentRepository.fetchEnvironmentsByFolderId(folderId).asJava
  }
}
