/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.status.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.configuration.HttpConnection;
import com.xebialabs.xlrelease.domain.environments.LiveDeploymentConfig;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.ConfigurationAutoconfigService;
import com.xebialabs.xlrelease.status.service.EndpointSetupDeploymentStatusService;
import com.xebialabs.xlrelease.status.service.WebhookBasicSetup;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import com.xebialabs.xlrelease.views.AutoconfigResponse;
import com.xebialabs.xlrelease.webhooks.authentication.NoAuthentication;
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource;
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u0005\n\u0001QA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0003<\u0001\u0011\u0005C\bC\u0003]\u0001\u0011%Q\fC\u0003h\u0001\u0011%\u0001NA\u0011TKR,\b/\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u000b\u0017\u000591/\u001a:wS\u000e,'B\u0001\u0007\u000e\u0003\u0019\u0019H/\u0019;vg*\u0011abD\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001E\t\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011!C\u0005\u0003=%\u0011A%\u00128ea>Lg\u000e^*fiV\u0004H)\u001a9m_flWM\u001c;Ti\u0006$Xo]*feZL7-Z\u0001\u0011G>tg-[4ve\u0006$\u0018n\u001c8Ba&\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005Y\f$BA\u0013\u000e\u0003\r\t\u0007/[\u0005\u0003O\t\u0012\u0001cQ8oM&<WO]1uS>t\u0017\t]5\u0002=\r|gNZ5hkJ\fG/[8o\u0003V$xnY8oM&<7+\u001a:wS\u000e,\u0007C\u0001\u0016-\u001b\u0005Y#B\u0001\u0006\u000e\u0013\ti3F\u0001\u0010D_:4\u0017nZ;sCRLwN\\!vi>\u001cwN\u001c4jON+'O^5dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003aMj\u0011!\r\u0006\u0003e5\t!B]3q_NLGo\u001c:z\u0013\t!\u0014GA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"Ba\u000e\u001d:uA\u0011A\u0004\u0001\u0005\u0006?\u0011\u0001\r\u0001\t\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006]\u0011\u0001\raL\u0001\u001eg\u0016$X\u000f]!qa2L7-\u0019;j_:\u001cF/\u0019;vg^+'\r[8pWR!Q\bQ'P!\tab(\u0003\u0002@\u0013\t\tr+\u001a2i_>\\')Y:jGN+G/\u001e9\t\u000b\u0005+\u0001\u0019\u0001\"\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\u0004\"a\u0011&\u000f\u0005\u0011C\u0005CA#\u0018\u001b\u00051%BA$\u0014\u0003\u0019a$o\\8u}%\u0011\u0011jF\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002J/!)a*\u0002a\u0001\u0005\u0006A1/\u001a:wKJLE\rC\u0003Q\u000b\u0001\u0007!)\u0001\u0005d_:4\u0017nZ%eQ\t)!\u000b\u0005\u0002T56\tAK\u0003\u0002V-\u0006YAO]1og\u0006\u001cG/[8o\u0015\t9\u0006,A\u0002tc2T!!W\u0007\u0002\u0005\u0011\u0014\u0017BA.U\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\u0001H2sK\u0006$X\r\u0013;ua\u0016sG\r]8j]R4uN],fE\"|wn\u001b\u000b\u0004=\u0012,\u0007CA0c\u001b\u0005\u0001'BA1\u000e\u0003\u0019!w.\\1j]&\u00111\r\u0019\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\u00053\u0001\u0019\u0001\"\t\u000b\u00194\u0001\u0019\u0001\"\u0002\u000bQLG\u000f\\3\u00023\r\u0014X-\u0019;f'R\fG/^:XK\nDwn\\6T_V\u00148-\u001a\u000b\u0006=&TGO\u001e\u0005\u0006\u0003\u001e\u0001\rA\u0011\u0005\u0006W\u001e\u0001\r\u0001\\\u0001\u0007g\u0016\u0014h/\u001a:\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0002r\u0017\u00059q/\u001a2i_>\\\u0017BA:o\u0005Q\u0019F/\u0019;vg\"#H\u000f]\"p]:,7\r^5p]\")Qo\u0002a\u0001=\u0006YQM^3oiN{WO]2f\u0011\u00159x\u00011\u0001y\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010Y\u0001\rK:4\u0018N]8o[\u0016tGo]\u0005\u0003{j\u0014A\u0003T5wK\u0012+\u0007\u000f\\8z[\u0016tGoQ8oM&<\u0007F\u0001\u0001\u0000!\u0011\t\t!a\u0004\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\tI!a\u0003\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0012\u0005\r!aB*feZL7-\u001a")
public class SetupApplicationStatusServiceImpl
implements EndpointSetupDeploymentStatusService {
    private final ConfigurationApi configurationApi;
    private final ConfigurationAutoconfigService configurationAutoconfigService;
    private final ConfigurationRepository configurationRepository;

    @Override
    @IsTransactional
    public WebhookBasicSetup setupApplicationStatusWebhook(String folderId, String serverId, String configId) {
        LiveDeploymentConfig config = (LiveDeploymentConfig)this.configurationRepository.read(configId);
        StatusHttpConnection server = (StatusHttpConnection)this.configurationRepository.read(serverId);
        Configuration webhookEndpoint = this.createHttpEndpointForWebhook(folderId, server.getTitle());
        Configuration statusWebhookSource = this.createStatusWebhookSource(folderId, server, webhookEndpoint, config);
        AutoconfigResponse autoconfigResponse = this.configurationAutoconfigService.autoconfigure(statusWebhookSource);
        return new WebhookBasicSetup(Predef$.MODULE$.Boolean2boolean(autoconfigResponse.getSuccess()), autoconfigResponse.getMessage(), autoconfigResponse.getDetails(), autoconfigResponse.getUrl(), statusWebhookSource.getId());
    }

    private Configuration createHttpEndpointForWebhook(String folderId, String title) {
        WebhookEndpoint.PostWebhookEndpoint webhookEndpoint = (WebhookEndpoint.PostWebhookEndpoint)Type.valueOf(WebhookEndpoint.PostWebhookEndpoint.class).getDescriptor().newInstance("post-webhook-endpoint");
        webhookEndpoint.setTitle(title);
        webhookEndpoint.setFolderId(folderId);
        webhookEndpoint.setProperty("path", (Object)("path-" + UUID.randomUUID()));
        webhookEndpoint.setProperty("authentication", (Object)new NoAuthentication());
        return this.configurationApi.addConfiguration((Configuration)webhookEndpoint);
    }

    private Configuration createStatusWebhookSource(String folderId, StatusHttpConnection server, Configuration eventSource, LiveDeploymentConfig config) {
        String statusWebhookEventSourceType = server.getStatusWebhookEventSourceName();
        StatusWebhookEventSource statusWebhookEventSource = (StatusWebhookEventSource)Type.valueOf((String)statusWebhookEventSourceType).getDescriptor().newInstance("status-event-webhook");
        statusWebhookEventSource.setTitle(server.getTitle());
        statusWebhookEventSource.setFolderId(folderId);
        statusWebhookEventSource.setProperty("eventSource", (Object)eventSource);
        statusWebhookEventSource.setSourceServer((HttpConnection)server);
        statusWebhookEventSource.setLiveDeploymentConfigs(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LiveDeploymentConfig[]{config}))).asJava());
        return this.configurationApi.addConfiguration((Configuration)statusWebhookEventSource);
    }

    public SetupApplicationStatusServiceImpl(ConfigurationApi configurationApi, ConfigurationAutoconfigService configurationAutoconfigService, ConfigurationRepository configurationRepository) {
        this.configurationApi = configurationApi;
        this.configurationAutoconfigService = configurationAutoconfigService;
        this.configurationRepository = configurationRepository;
    }
}

