package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

@Component
class XLRelease243StatusWebhookEventSourceUpgrade(configurationRepository: ConfigurationRepository) extends Upgrade with Logging {
  override def doUpgrade(): Boolean = {
    Try(migrateStatusWebhookEventSources()) match {
      case Success(_) => logger.info("Finished migrating existing Status Webhook Event Sources")
      case Failure(_) => logger.error("Unable to migrating existing Status Webhook Event Sources")
    }
    true
  }

  private def migrateStatusWebhookEventSources(): Unit = {
    configurationRepository.findAllByType[StatusWebhookEventSource](Type.valueOf(classOf[StatusWebhookEventSource])).asScala
      .foreach(s => {
        s.setTitle(s"${s.getTitle} [Migrated]")
        configurationRepository.update(s)
      })
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.3.0#2")
}
