from com.xebialabs.xlrelease.api.internal.filter import LiveDeploymentFilters
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

global endpoint, applicationTitle, logger


def getApplications(endpoint, applicationTitle):
    if endpoint:
        live_deployment_filters = LiveDeploymentFilters()
        live_deployment_filters.setEventSourceId(endpoint["id"])
        if applicationTitle:
            live_deployment_filters.setApplication(applicationTitle.strip())

        logger.debug("Searching for live deployments application for lookup with filter: {}", live_deployment_filters)
        live_deployment_apps = _liveDeploymentApi.searchLiveDeploymentApplications(live_deployment_filters)
        applications_lookup = []
        titles_set = set()
        for live_deployment_app in live_deployment_apps:
            title = live_deployment_app.getTitle()
            if title not in titles_set:
                applications_lookup.append(LookupResultElement(title, title))
                titles_set.add(title)
        return applications_lookup
    else:
        return []


result = getApplications(endpoint, applicationTitle)
