package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.v1.DeploymentServerApi
import com.xebialabs.xlrelease.api.v1.forms.DeploymentServerSetup
import com.xebialabs.xlrelease.domain.environments.LiveDeployment
import com.xebialabs.xlrelease.status.service.EndpointExternalDeploymentService
import com.xebialabs.xlrelease.views.AutoconfigResponse
import org.springframework.stereotype.Controller

@Controller
class DeploymentServerApiImpl(externalDeploymentService: EndpointExternalDeploymentService) extends DeploymentServerApi {

  override def autoconfigureDeploymentServer(statusWebhookEventSourceId: String): AutoconfigResponse =
    externalDeploymentService.autoconfigureExternalDeployments(statusWebhookEventSourceId)

  override def patchDeploymentServer(statusWebhookEventSourceId: String): Unit = {
    externalDeploymentService.patchExternalDeployments(statusWebhookEventSourceId)
  }

  override def setupDeploymentServer(deploymentServerSetup: DeploymentServerSetup): String =
    externalDeploymentService.setupExternalDeployments(deploymentServerSetup)

  override def getLiveDeployment(deploymentId: String): LiveDeployment =
    externalDeploymentService.getLiveDeployment(deploymentId)
}
