import React, { memo } from 'react';
import { DotIcon, DotConfirmationDialog, DotLink } from '@digital-ai/dot-components';
import './external-deployment-delete-application-dialog.component.less';

export interface ExternalDeploymentDeleteApplicationDialogProps {
    applicationName: string;
    connectionLabel: string;
    deploymentLink: string;
    isOpen: boolean;
    onCancel: () => void;
    onSubmit: () => void;
}

const ExternalDeploymentDeleteApplicationDialogComponent = ({
    applicationName,
    connectionLabel,
    deploymentLink,
    isOpen,
    onCancel,
    onSubmit,
}: ExternalDeploymentDeleteApplicationDialogProps) => {
    return (
        <DotConfirmationDialog
            message={
                <div data-test-id="confirmation-dialog-content">
                    <DotIcon className="warning-delete-app-icon" iconId="warning-solid" />
                    This will also do changes to original deployment on{' '}
                    <DotLink href={deploymentLink} target="_blank">
                        {connectionLabel}
                    </DotLink>{' '}
                    server.
                    <br /> <br />
                    Are you sure you want to delete <strong>{applicationName}</strong> application?
                </div>
            }
            onCancel={onCancel}
            onSubmit={onSubmit}
            open={isOpen}
            submitButtonProps={{
                label: 'Delete',
                type: 'destructive',
                startIcon: <DotIcon iconId="delete" />,
            }}
            title="Delete Application"
        />
    );
};

export const ExternalDeploymentDeleteApplicationDialog = memo(ExternalDeploymentDeleteApplicationDialogComponent);
