from com.xebialabs.xlrelease.api.internal.filter import LiveDeploymentFilters
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement

global endpoint, environmentTitle, logger


def getEnvironments(endpoint, environmentTitle):
    if endpoint:
        live_deployment_filters = LiveDeploymentFilters()
        live_deployment_filters.setEventSourceId(endpoint["id"])
        if environmentTitle:
            live_deployment_filters.setEnvironment(environmentTitle.strip())

        logger.debug("Searching for live deployments environment for lookup with filter: {}", live_deployment_filters)
        live_deployment_envs = _liveDeploymentApi.searchLiveDeploymentEnvironments(live_deployment_filters)
        environments_lookup = []
        titles_set = set()
        for live_deployment_env in live_deployment_envs:
            title = live_deployment_env.getTitle()
            if title not in titles_set:
                environments_lookup.append(LookupResultElement(title, title))
                titles_set.add(title)
        return environments_lookup
    else:
        return []


result = getEnvironments(endpoint, environmentTitle)
