global event, applicationTitle, environmentTitle, applicationVersion, deploymentStatuses

def match_event(event_property, input_property):
    return event_property and event_property.strip() == input_property.strip()

applicationTitle_matched = match_event(event.applicationTitle, applicationTitle)
environmentTitle_matched = match_event(event.environmentTitle, environmentTitle)
applicationVersion_matched = match_event(event.deploymentState.versionTag, applicationVersion)
deploymentStatus_matched = event.deploymentState.statusGroup in deploymentStatuses

result = all([applicationTitle_matched, environmentTitle_matched, applicationVersion_matched, deploymentStatus_matched])

if result:
    print "Received matching event for application '{}' in environment '{}' with version '{}' and deployment status '{}'\n".format(event.applicationTitle, event.environmentTitle, event.deploymentState.versionTag, event.deploymentState.statusGroup)
