import React from 'react';
import { DotButton, DotCardContent, DotCardFooter, DotCardHeader, DotLink } from '@digital-ai/dot-components';
import { mockResizeObserver, mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { DeploymentServerCard } from './deployment-server-card.component';
import { mockArgoDeploymentServer } from '../../__mocks__/deployment-server.mocks';

describe('DeploymentServerCard', () => {
    const onClickMock = jest.fn();

    const mountComponent = (props = { deploymentServer: mockArgoDeploymentServer, onClick: onClickMock }) =>
        mountWithTheme(<DeploymentServerCard {...props} />);

    const getWrapperDiv = (wrapper: ReactWrapper) => wrapper.find('div.deployment-server-card');
    const getButton = (wrapper: ReactWrapper) => wrapper.find('button.run-deployment-server-btn');

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        const wrapper = mountComponent();

        const wrapperDiv = getWrapperDiv(wrapper);
        expect(wrapperDiv).toExist();

        const cardHeader = wrapperDiv.find(DotCardHeader);
        expect(cardHeader).toExist();
        expect(cardHeader.prop('title')).toBe(mockArgoDeploymentServer.eventSourceTitle);
        expect(cardHeader.prop('subheader')).toBe(`${mockArgoDeploymentServer.connectionLabel}`);

        const cardContent = wrapperDiv.find(DotCardContent);
        expect(cardContent).toExist();
        const link = cardContent.find(DotLink);
        expect(link).toExist();
        expect(link.prop('href')).toBe(mockArgoDeploymentServer.connectionUrl);

        const cardFooter = wrapperDiv.find(DotCardFooter);
        expect(cardFooter).toExist();
        const button = cardFooter.find(DotButton);
        expect(button).toExist();
        expect(button.text()).toBe('Use server');
    });

    it('should call onClick when button is clicked', () => {
        const wrapper = mountComponent();

        const button = getButton(wrapper);
        expect(button).toExist();
        button.simulate('click');
        expect(onClickMock).toHaveBeenCalledWith(mockArgoDeploymentServer.eventSourceId);
    });
});
