import React from 'react';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { CheckboxSkeleton } from './checkbox-skeleton.component';
import * as helpers from '@xlr-ui/app/features/workflow/helper';
import { DeploymentServerConnectionsSkeleton } from './deployment-server-connections-skeleton.component';

describe('DeploymentServerConnectionsSkeleton', () => {
    const mountComponent = () => mountWithTheme(<DeploymentServerConnectionsSkeleton />);
    const getWrapperDiv = (wrapper: ReactWrapper) => wrapper.find('div.deployment-server-connections-skeleton');
    const getCheckboxItemsWrapperDiv = (wrapper: ReactWrapper) => wrapper.find('div.deployment-server-connection-checkbox-items');

    it('should render properly', () => {
        const numberOfItems = 4;
        const getRandomIntSpy = jest.spyOn(helpers, 'getRandomInt').mockReturnValue(numberOfItems);

        const wrapper = mountComponent();

        const wrapperDiv = getWrapperDiv(wrapper);
        expect(wrapperDiv).toExist();

        const selectAllCheckboxSkeleton = wrapperDiv.childAt(0).find(CheckboxSkeleton);
        expect(selectAllCheckboxSkeleton).toExist();

        const checkboxItemsWrapperDiv = getCheckboxItemsWrapperDiv(wrapper);
        expect(checkboxItemsWrapperDiv).toExist();

        const checkboxSkeletons = checkboxItemsWrapperDiv.find(CheckboxSkeleton);
        expect(checkboxSkeletons).toExist();
        expect(checkboxSkeletons).toHaveLength(numberOfItems);

        getRandomIntSpy.mockRestore();
    });
});
