package com.xebialabs.xlrelease.status.service.script

import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.stereotype.Component


trait FilterScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource, event: Event): Boolean
}

@Component
class FilterScriptExecutor(
                            runnerScriptService: RunnerScriptService
                          ) extends FilterScriptService with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource, event: Event): Boolean = {
    logger.debug(s"Executing filter script for StatusWebhookEventSource ${connection.getName}")
    val inputParams = buildDefaultInputParams(connection)
    inputParams.put("content", event.getProperty("content"))
    runnerScriptService.executeScript[Boolean](
      connection.filterScript,
      inputParams,
      new TypeReference[Boolean] {}
    )
  }
}
