package com.xebialabs.xlrelease.status.webhook.events

import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.domain.environments.{ApplicationSource, DeploymentState, DeploymentTarget}
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer

import scala.beans.BeanProperty

@Metadata(virtual = false, label = "Deployment server webhook reques event")
@JsonSerialize(using = classOf[CiSerializer])
class DeploymentServerEvent extends Event {
  @BeanProperty
  @Property(label = "Operation")
  var operation: String = _

  @BeanProperty
  @Property(description = "Status Webhook Event Source Configuration ID associated with the deployment.")
  var configId: String = _

  @BeanProperty
  @Property(description = "Application correlation ID.")
  var applicationCuid: String = _

  @BeanProperty
  @Property(description = "Application title.")
  var applicationTitle: String = _

  @BeanProperty
  @Property(description = "Application source associated with the event.", nested = true)
  var applicationSource: ApplicationSource = _

  @BeanProperty
  @Property(description = "Environment correlation ID.")
  var environmentCuid: String = _

  @BeanProperty
  @Property(description = "Environment title.")
  var environmentTitle: String = _

  @BeanProperty
  @Property(description = "Deployment target associated with the event.", nested = true)
  var deploymentTarget: DeploymentTarget = _

  @BeanProperty
  @Property(description = "Snapshot state of deployment", nested = true)
  @JsonSerialize(using = classOf[CiSerializer])
  var deploymentState: DeploymentState = _
}
