import React from 'react';
import { CheckboxSkeleton } from './checkbox-skeleton.component';
import { getRandomInt } from '@xlr-ui/app/features/workflow/helper';
import './deployment-server-connections-skeleton.component.less';

export const DeploymentServerConnectionsSkeleton = () => {
    return (
        <div className="deployment-server-connections-skeleton">
            <CheckboxSkeleton />
            <div className="deployment-server-connection-checkbox-items">
                {[...Array(getRandomInt(1, 7))].map((_, index: number) => (
                    <CheckboxSkeleton key={index} />
                ))}
            </div>
        </div>
    );
};
