package com.xebialabs.xlrelease.status.repository.persistence.data

import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.FOLDERS
import com.xebialabs.xlrelease.status.repository.persistence.LiveDeploymentSchema.LIVE_DEPLOYMENT

import java.sql.ResultSet
import scala.util.Using

case class LiveDeploymentRow(ciUid: CiUid, folderId: String, deploymentId: String, json: String)

object LiveDeploymentRow extends CompressionSupport {
  def fromResultSet(rs: ResultSet): LiveDeploymentRow = {
    val data = Using.resource(rs.getBinaryStream(LIVE_DEPLOYMENT.CONTENT)) { s =>
      decompress(s)
    }
    LiveDeploymentRow(
      ciUid = rs.getString(LIVE_DEPLOYMENT.CI_UID),
      folderId = rs.getString(FOLDERS.FOLDER_ID),
      deploymentId = rs.getString(LIVE_DEPLOYMENT.DEPLOYMENT_ID),
      json = data
    )
  }
}
