import React from 'react';
import { CssCell, CssGrid } from '@digital-ai/dot-components';

import { mountWithTheme, mockResizeObserver, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import * as helpers from '@xlr-ui/app/features/workflow/helper';
import { DeploymentServerSkeletons } from './deployment-server-skeletons.component';
import { DeploymentServerCardSkeleton } from './deployment-server-card-skeleton.component';

describe('DeploymentServerSkeletons', () => {
    const mountComponent = () => mountWithTheme(<DeploymentServerSkeletons />);
    const getSkeletonsCard = (wrapper: ReactWrapper) => wrapper.find('div.deployment-server-skeletons-card');

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        const numberOfItems = 2;
        const getRandomIntSpy = jest.spyOn(helpers, 'getRandomInt').mockReturnValue(numberOfItems);

        const wrapper = mountComponent();

        const cards = getSkeletonsCard(wrapper);
        expect(cards).toExist();
        expect(cards).toHaveLength(numberOfItems);

        cards.forEach((card) => {
            const cssGrid = card.find(CssGrid);
            expect(cssGrid).toExist();

            const cssCells = cssGrid.find(CssCell);
            expect(cssCells).toExist();
            expect(cssCells).toHaveLength(numberOfItems);

            cssCells.forEach((cssCell) => {
                const cardSkeleton = cssCell.find(DeploymentServerCardSkeleton);
                expect(cardSkeleton).toExist();
            });
        });

        getRandomIntSpy.mockRestore();
    });
});
