import React from 'react';
import { DotAvatar, DotCard, DotCardHeader, DotSkeleton } from '@digital-ai/dot-components';
import './external-deployment-card-skeleton.component.less';

export const ExternalDeploymentCardSkeletonComponent = () => {
    return (
        <DotCard className="external-deployment-card-skeleton-wrapper">
            <div className="external-deployments-card-skeleton-content">
                <div className="external-deployments-card-skeleton-data">
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="30%" />
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                </div>
                <div className="external-deployment-card-skeleton-server">
                    <div>
                        <DotSkeleton className="avatar-skeleton" variant="circular">
                            <DotAvatar alt="" text="" type="text" />
                        </DotSkeleton>
                    </div>
                    <div>
                        <DotSkeleton data-testid="title-skeleton" width="100%">
                            <DotCardHeader avatar={<DotAvatar alt="" text="" type="text" />} subheader="" subheaderSize="large" title="" titleSize="large" />
                        </DotSkeleton>
                    </div>
                </div>
                <div className="external-deployments-card-skeleton-data">
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                </div>
                <div className="external-deployments-card-skeleton-data">
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                    <DotSkeleton className="card-content-line-skeleton" height="25px" variant="text" width="100%" />
                </div>
            </div>
        </DotCard>
    );
};
