import React, { ReactNode } from 'react';
import { DotAvatar, DotButton, DotCard, DotCardHeader, DotSkeleton } from '@digital-ai/dot-components';
import './deployment-server-card-skeleton.component.less';

export const DeploymentServerCardSkeleton = () => {
    const renderCardContentLineSkeletons = (numberOfSkeletons: number): ReactNode[] => {
        return [...Array(numberOfSkeletons)].map((_, index: number) => (
            <DotSkeleton className="card-content-line-skeleton" key={index} variant="rectangular" />
        ));
    };

    return (
        <DotCard className="deployment-server-card-skeleton-wrapper">
            <div className="card-content">
                <div className="deployment-server-card-skeleton-header">
                    <div>
                        <DotSkeleton className="avatar-skeleton" variant="circular">
                            <DotAvatar alt="" text="" type="text" />
                        </DotSkeleton>
                    </div>
                    <div className="header-right">
                        <DotSkeleton data-testid="title-skeleton" width="100%">
                            <DotCardHeader avatar={<DotAvatar alt="" text="" type="text" />} subheader="" subheaderSize="large" title="" titleSize="large" />
                        </DotSkeleton>
                    </div>
                </div>
                <div>{renderCardContentLineSkeletons(2)}</div>
            </div>

            <div className="card-footer">
                <DotSkeleton data-testid="footer-button-skeleton" variant="rectangular">
                    <DotButton type="outlined">Use server</DotButton>
                </DotSkeleton>
            </div>
        </DotCard>
    );
};
