package com.xebialabs.xlrelease.status.sse

import com.xebialabs.xlrelease.status.sse.service.ServerSentEventsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import jakarta.ws.rs.core.MediaType
import jakarta.ws.rs.{DELETE, POST, Path, Produces}

@Path("/sse-applications")
@Controller
@Produces(Array(MediaType.APPLICATION_JSON))
class ServerSentEventsResource @Autowired()(val serverSentEventsService: ServerSentEventsService) {

  @POST
  @Path("/application-status/register")
  def registerExternalDeploymentStream(): Unit = {
     serverSentEventsService.add()
  }

  @DELETE
  @Path("/application-status/register")
  def unregisterExternalDeploymentStream(): Unit = {
    serverSentEventsService.remove()
  }

}

