package com.xebialabs.xlrelease.status.service.script

import com.xebialabs.xlrelease.domain.ScriptHelper
import com.xebialabs.xlrelease.script.builder.{ScriptContextBuilder, _}
import com.xebialabs.xlrelease.script.{EncryptionHelper, XlrScript, XlrScriptContext}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource

private abstract class BaseScriptContextBuilder(eventSource: StatusWebhookEventSource) extends ScriptContextBuilder {
  val scriptProperty: String

  private val sourceServer: StatusHttpConnection = eventSource.sourceServer.asInstanceOf[StatusHttpConnection]

  final val StatusScriptProperty = "statusScript"
  final val AutoconfigScriptProperty = "autoconfigScript"
  final val FiltersRequestScriptProperty = "filtersRequest"
  final val PatchScriptProperty = "patchScript"
  final val CleanupScriptProperty = "cleanupScript"

  withLogger().withScriptApi()
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  protected def addConnectionServerAttributes(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(sourceServer)
    context.addCiAsMap("connectionServer", sourceServer)
  }

  protected def addConnectionAttributes(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(eventSource)
    context.addCiAsMap("connection", eventSource)
  }

  protected def addScript(context: XlrScriptContext): Unit = {
    val script = ScriptHelper.getScript(scriptProperty, eventSource, s".$scriptProperty")
    val name = s"${eventSource.getType}[${eventSource.getTitle}-$scriptProperty]"
    context.addScript(XlrScript.byContent(name = name, content = script, wrap = false, checkPermissions = false))
  }
}
