import React from 'react';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { DotCard, DotTypography } from '@digital-ai/dot-components';
import { SetupDeploymentServer } from './setup-deployment-server.component';

describe('SetupDeploymentServerComponent', () => {
    let wrapper: ReactWrapper;
    const onConnect = jest.fn();
    const onOnboard = jest.fn();

    const defaultProps = {
        onConnect,
        onOnboard,
    };

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<SetupDeploymentServer {...props} />);
    };

    afterEach(() => jest.resetAllMocks());

    it('should render component with correct elements', () => {
        mount();
        const header = wrapper.findWhere((node) => node.is(DotTypography) && node.props().variant === 'h1');
        expect(header.exists()).toBe(true);
        expect(header.text()).toBe('Setup live deployments');

        const subtitle = wrapper.findWhere((node) => node.is(DotTypography) && node.props().className === 'content-header-subtitle');
        expect(subtitle.exists()).toBe(true);
        expect(subtitle.text()).toBe('Setup live deployment anywhere in your pipeline');

        const cards = wrapper.find(DotCard);
        expect(cards.length).toBe(2);

        const onboardCard = wrapper.findWhere((node) => node.is(DotCard) && node.props()['data-testid'] === 'digitalai-launch');
        expect(onboardCard.exists()).toBe(true);
        expect(onboardCard.find(DotTypography).at(1).text()).toBe(
            'Set up new deployments in external system like Digital.ai Deploy or ArgoCD by using step-by-step workflow',
        );

        const connectCard = wrapper.findWhere((node) => node.is(DotCard) && node.props()['data-testid'] === 'digitalai-disconnected');
        expect(connectCard.exists()).toBe(true);
        expect(connectCard.find(DotTypography).at(1).text()).toBe('Listen to existing deployments from external systems like Digital.ai Deploy or ArgoCD');
    });

    it('should call onOnboard when onboard button is clicked', () => {
        mount();
        const onboardButton = wrapper.find('button[data-testid="setup-deployment-server-onboard-btn"]');
        expect(onboardButton).toExist();
        onboardButton.simulate('click');
        expect(onOnboard).toHaveBeenCalled();
    });

    it('should call onConnect when connect button is clicked', () => {
        mount();
        const connectButton = wrapper.find('button[data-testid="setup-deployment-server-connect-btn"]');
        expect(connectButton).toExist();
        connectButton.simulate('click');
        expect(onConnect).toHaveBeenCalled();
    });
});
