package com.xebialabs.xlrelease.status.service.script

import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.script.jython.{JythonScriptService, XlrJythonSupport}
import com.xebialabs.xlrelease.status.service.script.ExternalDeploymentScriptExecutor._
import com.xebialabs.xlrelease.status.webhook.events.{DeploymentServerEvent, RemoteStatusWebhookEventSource, StatusWebhookEventSource}
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.stereotype.Component

trait ExternalDeploymentScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource): AnyRef
}

@Component
class ExternalDeploymentScriptExecutor(
                            val scriptService: JythonScriptService,
                            runnerScriptService: RunnerScriptService
                          ) extends XlrJythonSupport
  with ExternalDeploymentScriptService
  with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource): AnyRef = {
    logger.debug(s"Executing status script for StatusWebhookEventSource ${connection.getName}")
    if (connection.isInstanceOf[RemoteStatusWebhookEventSource]) {
      runnerScriptService.executeScript[DeploymentServerEvent](
        connection.statusScript,
        buildDefaultInputParams(connection))
    } else {
      val scriptContext = createStatusScriptContext(connection)
      executeScript(scriptContext)
      scriptContext.getAttribute("data")
    }
  }
}

private class StatusScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = StatusScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionAttributes(context)
    addConnectionServerAttributes(context)
    addScript(context)
  }
}

private object ExternalDeploymentScriptExecutor {
  def createStatusScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new StatusScriptContextBuilder(connection).build()
  }
}
