import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { FolderExternalDeploymentsState } from './external-deployments.reducer';
import {
    Application,
    Environment,
    ExternalDeploymentPage,
    LiveDeploymentData,
    PluginInfo,
    Server,
    StatusWebhookEventSource,
    WebhookEndpoint,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
} from '../external-deployment.types';

export const getFolderExternalDeployments = (state: RootState): FolderExternalDeploymentsState => state.folderExternalDeployments;
export const getApplications = (state: RootState): Map<string, Application> => getFolderExternalDeployments(state).applications;
export const getEnvironments = (state: RootState): Map<string, Environment> => getFolderExternalDeployments(state).environments;
export const getConnectionServersSelector = (state: RootState): Map<string, Server> => getFolderExternalDeployments(state).connectionServers;
export const getLiveDeploymentsSelector = (state: RootState): Array<LiveDeploymentData> => getFolderExternalDeployments(state).liveDeployments;
export const getExternalDeploymentPageSelector = (state: RootState): ExternalDeploymentPage => getFolderExternalDeployments(state).page;
export const getExternalDeploymentCountSelector = (state: RootState): number => getFolderExternalDeployments(state).count;
export const getIsLoadingSelector = (state: RootState): boolean => getFolderExternalDeployments(state).isLoading;
export const getIsTableViewSelector = (state: RootState): boolean => getFolderExternalDeployments(state).isTableView;
export const getConfigDetailsSelector = (state: RootState): WebhookSourceAutoConfigDetails | undefined => getFolderExternalDeployments(state).configDetails;
export const getWebhookSourcesSelector = (state: RootState): Array<WebhookSource> => getFolderExternalDeployments(state).webhookSources;
export const getServersSelector = (state: RootState): Array<Server> => getFolderExternalDeployments(state).servers;
export const getWebhookSourceFiltersSelector = (state: RootState): WebhookSourceFilter | undefined => getFolderExternalDeployments(state).webhookSourceFilters;
export const getFilterEventSourceSelector = (state: RootState): WebhookEndpoint | undefined => getFolderExternalDeployments(state).filterEventSource;
export const getConditionSelector = (state: RootState): string => getFolderExternalDeployments(state).condition;
export const getConnectionErrorsSelector = (state: RootState): Array<string> => getFolderExternalDeployments(state).connectionErrors;
export const getDisconnectedServers = (state: RootState): Array<string> => getFolderExternalDeployments(state).disconnectedServers;
export const getPreSelectedServer = (state: RootState): Server | undefined => getFolderExternalDeployments(state).preSelectedServer;
export const getValidServerCards = (state: RootState): Array<PluginInfo> => getFolderExternalDeployments(state).validServerCards;
export const getStatusWebhookEventSourcesSelector = (state: RootState): Array<StatusWebhookEventSource> =>
    getFolderExternalDeployments(state).statusWebhookEventSources;
