import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';

export interface LiveDeploymentConfigComponentPortalProp {
    folder: Folder;
    onAddClick: (t: boolean) => void;
}

export const LiveDeploymentConfigComponentPortal = (props: LiveDeploymentConfigComponentPortalProp) => {
    const { onAddClick } = props;

    return (
        <ActionToolbarPortalContainer>
            <DotButton
                onClick={() => {
                    onAddClick(true);
                }}
                type="primary"
            >
                Add
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
