import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import { CheckboxSkeleton } from './checkbox-skeleton.component';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';

describe('CheckboxSkeleton', () => {
    const mountComponent = () => mountWithTheme(<CheckboxSkeleton />);

    const getCheckboxSkeletonWrapper = (wrapper: ReactWrapper) => wrapper.find('div.checkbox-skeleton-wrapper');
    const getCheckboxLabelSkeletonWrapper = (wrapper: ReactWrapper) => wrapper.find('div.checkbox-label-skeleton-wrapper');
    const getSkeletonWithClass = (wrapper: ReactWrapper, className: string) =>
        wrapper.findWhere((node) => node.is(DotSkeleton) && node.props().className === className);

    it('should render properly', () => {
        const wrapper = mountComponent();

        const skeletonWrapper = getCheckboxSkeletonWrapper(wrapper);
        expect(skeletonWrapper).toExist();

        const checkboxSkeleton = getSkeletonWithClass(wrapper, 'checkbox-skeleton');
        expect(checkboxSkeleton).toExist();
        expect(checkboxSkeleton.props().variant).toBe('rectangular');

        const checkboxLabelWrapper = getCheckboxLabelSkeletonWrapper(wrapper);
        expect(checkboxLabelWrapper).toExist();

        const checkboxLabelSkeleton = getSkeletonWithClass(wrapper, 'checkbox-label-skeleton');
        expect(checkboxLabelSkeleton).toExist();
        expect(checkboxLabelSkeleton.props().variant).toBe('rectangular');
    });
});
