import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ChooseOnboardConnect } from './choose-onboard-connect.component';

describe('ChooseOnboardConnect component', () => {
    let wrapper: ReactWrapper;

    beforeEach(() => {
        wrapper = mountWithTheme(<ChooseOnboardConnect />);
    });

    afterEach(() => {
        wrapper.unmount();
    });

    const search = (selector: string) => wrapper.find(`.choose-onboard-connect ${selector}`);
    const searchByTestId = (testId: string) => wrapper.find(`.choose-onboard-connect [data-testid="${testId}"]`);

    it('should render the content header', () => {
        const header = search('.content-header');
        expect(header.find('.dot-typography').at(0).text()).toStrictEqual('Setup live deployments');
        expect(header.find('.content-header-subtitle').at(0).text()).toStrictEqual('Setup live deployment anywhere in your pipeline');
    });

    it('should render the Onboard new deployment card', () => {
        const card = searchByTestId('digitalai-launch');
        expect(card.find('.dot-typography').at(0).text()).toStrictEqual('Onboard new deployment');
        expect(card.find('.content-card-description').at(0).text()).toStrictEqual(
            'Set up new deployments in external system like Digital.ai Deploy or ArgoCD by using step-by-step workflow',
        );
        expect(card.find('.content-card-button .dot-button').at(0).text()).toStrictEqual('Onboard');
    });

    it('should render the Connect existing deployment card', () => {
        const card = searchByTestId('digitalai-disconnected');
        expect(card.find('.dot-typography').at(0).text()).toStrictEqual('Connect existing deployment');
        expect(card.find('.content-card-description').at(0).text()).toStrictEqual(
            'Listen to existing deployments from external systems like Digital.ai Deploy or ArgoCD',
        );
        expect(card.find('.content-card-button .dot-button').at(0).text()).toStrictEqual('Connect');
    });
});
