import React from 'react';
import { Provider } from 'react-redux';
import { ReactWrapper } from 'enzyme';
import { mountComponentWithStore } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderLiveDeploymentConfigPage, FolderLiveDeploymentConfigProps } from './folder-live-deployment-config';
import { LiveDeploymentConfigurationTable } from './configure/live-deployment-configuration-table.component';

describe('Live deployment config', () => {
    let wrapper: ReactWrapper;

    const defaultProps: FolderLiveDeploymentConfigProps = {
        folder: { id: '1', title: 'One' },
        forceSetup: false,
    };

    const mountComponent = (props: FolderLiveDeploymentConfigProps = defaultProps) =>
        (wrapper = mountComponentWithStore(<FolderLiveDeploymentConfigPage {...props} />));

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render FolderLiveDeploymentConfigPage', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(LiveDeploymentConfigurationTable)).toExist();
    });
});
