import { ConnectionServerMetadata, DeploymentServer, LiveDeploymentConfigData } from '../deployment-server.types';
import { Server, StatusWebhookEventSource } from '../../external-deployments/external-deployment.types';

export const mockArgoDeploymentServer: DeploymentServer = {
    connectionIconLocation: 'icon-location',
    connectionId: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    connectionLabel: 'Argo',
    connectionTitle: 'ArgoCD',
    connectionType: 'argocd.ArgoCD',
    connectionUrl: 'https://localhost:7775',
    eventSourceId: 'Configuration/Custom/Configurationa263c597b7734f49960b8417c8278d72',
    eventSourceTitle: 'ArgoCD',
};

export const mockDeployDeploymentServer: DeploymentServer = {
    connectionIconLocation: 'icon-location',
    connectionId: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e9',
    connectionLabel: 'Digital.AI',
    connectionTitle: 'Deploy',
    connectionType: 'digitalai.Deploy',
    connectionUrl: 'https://localhost:4516',
    eventSourceId: 'Configuration/Custom/Configurationa263c597b7734f49960b8417c8278d73',
    eventSourceTitle: 'The Deploy',
};

export const mockLiveDeploymentConfigData: LiveDeploymentConfigData = {
    connectionLabel: 'connection-provider',
    connectionTitle: 'connection-title',
    connectionType: 'connection-type',
    connectionUrl: 'http://localhost',
    eventSourceId: 'event-source-id',
    eventSourceType: 'event-source-type',
    filterProperties: { key: 'value' },
    id: 'config-id',
    title: 'config-title',
};
export const mockArgoConnectionServerMetadata: ConnectionServerMetadata = {
    iconLocation: 'icon-location',
    subheader: 'Argo',
    title: 'ArgoCD',
    type: 'argocd.ArgoCD',
};

export const mockDeployConnectionServerMetadata: ConnectionServerMetadata = {
    iconLocation: 'icon-location',
    subheader: 'Digital.AI',
    title: 'Deploy',
    type: 'digitalai.Deploy',
};

export const mockArgoWebhookSource: StatusWebhookEventSource = {
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configurationa263c597b7734f49960b8417c8278d72',
    sourceServer: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.StatusWebhookEventSource',
};

export const argoServerMock: Server = {
    authenticationMethod: 'None',
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.ArgoCD',
    url: 'https://localhost:7775',
    username: 'admin',
    variableMapping: new Map<string, string>(),
};
