package com.xebialabs.xlrelease.status.service

import com.xebialabs.deployit.ClosingExceptionMapper.{X_EXCEPTION_TYPE, X_PATH}
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor
import com.xebialabs.deployit.rest.mappers.DeployitExceptionHandler
import com.xebialabs.deployit.{ClosingExceptionMapper, ServerConfiguration}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Date
import jakarta.ws.rs.core.{MediaType, Response}
import jakarta.ws.rs.ext.{ExceptionMapper, Provider}

@Provider
@Component
class EndpointExternalDeploymentErrorMapper @Autowired()(val config: ServerConfiguration)
  extends ClosingExceptionMapper[EndpointExternalDeploymentError](false)
    with ExceptionMapper[EndpointExternalDeploymentError] {

  override protected def handleException(exception: EndpointExternalDeploymentError): Response =
      Response.status(400).entity(DeployitExceptionHandler.getJsonEntity(exception))
        .header(X_EXCEPTION_TYPE, exception.getClass.getName)
        .header(X_PATH, PathInterceptor.PATH.get)
        .header("Date", new Date)
        .header("X-Entity", "true")
        .`type`(MediaType.APPLICATION_JSON_TYPE)
        .build
}
