import { Order, RowsPerPageOption } from '@digital-ai/dot-components';

export interface DeploymentServer {
    connectionIconLocation: string;
    connectionId: string;
    connectionLabel: string;
    connectionTitle: string;
    connectionType: string;
    connectionUrl: string;
    eventSourceId: string;
    eventSourceTitle: string;
}

export interface LiveDeploymentConfigPage {
    folderId?: string;
    order: Order;
    orderBy: string;
    page: number;
    resultsPerPage: RowsPerPageOption;
}

export interface LiveDeploymentConfigData {
    connectionLabel: string;
    connectionTitle: string;
    connectionType: string;
    connectionUrl: string;
    eventSourceId: string;
    eventSourceType: string;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    filterProperties: Record<string, any>;
    id: string;
    title: string;
}

export interface ConnectionServerMetadata {
    iconLocation: string;
    subheader: string;
    title: string;
    type: string;
}
