import React, { memo } from 'react';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';
import { ConnectionDialog } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/common/connection-dialog/connection-dialog.component';
import { folderExternalDeployments } from '../../ducks/external-deployments.reducer';
import './application-create-server-component.less';

export interface ApplicationCreateServerFormProp {
    closeForm: () => void;
    folder: Folder;
    serverId?: string;
    serverType?: string;
}

const CreateServerFormComponent = (props: ApplicationCreateServerFormProp) => {
    const { serverType, closeForm, serverId, folder } = props;
    const { updateServerList } = folderExternalDeployments.actions;

    const handleCancelConfiguration = (): void => {
        closeForm();
    };

    const handleSaveConfiguration = (): void => {
        closeForm();
    };

    return (
        <ConnectionDialog
            configurationSaveAction={updateServerList}
            connectionId={serverId}
            folderId={folder.id}
            isNewInstance={!serverId}
            keyOrName={'server'}
            onCancel={handleCancelConfiguration}
            onSave={handleSaveConfiguration}
            referencedType={serverType || ''}
        />
    );
};

export const CreateServerForm = memo(CreateServerFormComponent);
