/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.status.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.xlrelease.api.internal.filter.LiveDeploymentFilters;
import com.xebialabs.xlrelease.api.internal.views.LiveDeploymentOrderDirection;
import com.xebialabs.xlrelease.api.internal.views.LiveDeploymentOrderMode;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.ApplicationSource;
import com.xebialabs.xlrelease.domain.environments.DeploymentState;
import com.xebialabs.xlrelease.domain.environments.DeploymentTarget;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.environments.LiveDeployment;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.repository.EnvironmentLabelRepository;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.repository.EnvironmentStageRepository;
import com.xebialabs.xlrelease.environments.repository.sql.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.data.RowWithContent;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.status.repository.persistence.LiveDeploymentPersistence;
import com.xebialabs.xlrelease.status.repository.persistence.data.LiveDeploymentRow;
import com.xebialabs.xlrelease.status.service.LiveDeploymentService;
import com.xebialabs.xlrelease.status.sse.service.ServerSentEventsService;
import com.xebialabs.xlrelease.status.webhook.events.CreateLiveDeploymentEvent;
import com.xebialabs.xlrelease.status.webhook.events.DeleteLiveDeploymentEvent;
import com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent;
import com.xebialabs.xlrelease.status.webhook.events.LiveDeploymentEvent;
import com.xebialabs.xlrelease.status.webhook.events.UpdateLiveDeploymentEvent;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ReleasePageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u0005b\u0001\u0002\u0010 \u0001)B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\u0019\u0004A\u0011A4\t\u000f=\u0004!\u0019!C\u0005a\"1A\u0010\u0001Q\u0001\nEDQ! \u0001\u0005ByDq!a\u0016\u0001\t\u0013\tI\u0006C\u0005\u0002(\u0002\t\n\u0011\"\u0003\u0002*\"I\u0011Q\u0019\u0001\u0012\u0002\u0013%\u0011q\u0019\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\ti\u000e\u0001C\u0001\u0003?Dq!!;\u0001\t\u0003\nY\u000fC\u0004\u0002z\u0002!\t%a?\t\u000f\t%\u0003\u0001\"\u0011\u0003L!9!q\f\u0001\u0005\n\t\u0005\u0004b\u0002B0\u0001\u0011%!1\u0010\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00030\u0002!\tE!-\t\u000f\t\u001d\u0007\u0001\"\u0011\u0003J\"9!\u0011\u001b\u0001\u0005B\tM\u0007b\u0002Bt\u0001\u0011\u0005#\u0011\u001e\u0005\b\u0005_\u0004A\u0011\tBy\u0011\u001d\u00119\u0010\u0001C!\u0005s\u0014\u0011\u0004T5wK\u0012+\u0007\u000f\\8z[\u0016tGoU3sm&\u001cW-S7qY*\u0011\u0001%I\u0001\bg\u0016\u0014h/[2f\u0015\t\u00113%\u0001\u0004ti\u0006$Xo\u001d\u0006\u0003I\u0015\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0019:\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0013aA2p[\u000e\u00011\u0003\u0002\u0001,cU\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u0005Ua\u0015N^3EKBdw._7f]R\u001cVM\u001d<jG\u0016\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000bMdg\r\u000e6\u000b\u0003i\n\u0001b\u001a:jujdW\rZ\u0005\u0003y]\u0012q\u0001T8hO&tw-A\u000beKBdw._7f]R\u0004VM]:jgR,gnY3\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015a\u00039feNL7\u000f^3oG\u0016T!aQ\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002F\u0001\nIB*\u001b<f\t\u0016\u0004Hn\\=nK:$\b+\u001a:tSN$XM\\2f\u0003U\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001\u0013'\u000e\u0003%S!a\u0011&\u000b\u0005-\u001b\u0013\u0001D3om&\u0014xN\\7f]R\u001c\u0018BA'J\u0005U\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8SKB|7/\u001b;pef\fQ#\u001a8wSJ|g.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002I!&\u0011\u0011+\u0013\u0002\u0016\u000b:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z\u0003i)gN^5s_:lWM\u001c;Ti\u0006<WMU3q_NLGo\u001c:z!\tAE+\u0003\u0002V\u0013\nQRI\u001c<je>tW.\u001a8u'R\fw-\u001a*fa>\u001c\u0018\u000e^8ss\u000692/\u001a:wKJ\u001cVM\u001c;Fm\u0016tGo]*feZL7-\u001a\t\u00031rk\u0011!\u0017\u0006\u0003AiS!aW\u0011\u0002\u0007M\u001cX-\u0003\u0002^3\n92+\u001a:wKJ\u001cVM\u001c;Fm\u0016tGo]*feZL7-Z\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\bC\u00011e\u001b\u0005\t'B\u00012d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0007\u000eJ!!Z1\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003\u0019a\u0014N\\5u}Q9\u0001.\u001b6lY6t\u0007C\u0001\u001a\u0001\u0011\u0015it\u00011\u0001?\u0011\u00151u\u00011\u0001H\u0011\u0015qu\u00011\u0001P\u0011\u0015\u0011v\u00011\u0001T\u0011\u00151v\u00011\u0001X\u0011\u0015qv\u00011\u0001`\u00039!UMZ1vYR,fn\u001b8po:,\u0012!\u001d\t\u0003eft!a]<\u0011\u0005QlS\"A;\u000b\u0005YL\u0013A\u0002\u001fs_>$h(\u0003\u0002y[\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAX&A\bEK\u001a\fW\u000f\u001c;V].twn\u001e8!\u0003E\u0011\u0017\r^2i'\u00064Xm\u0014:Va\u0012\fG/\u001a\u000b\u0006\u007f\u0006E\u0011Q\b\t\u0006\u0003\u0003\tY!\u001d\b\u0005\u0003\u0007\t9AD\u0002u\u0003\u000bI\u0011AL\u0005\u0004\u0003\u0013i\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0003MSN$(bAA\u0005[!9\u00111\u0003\u0006A\u0002\u0005U\u0011\u0001\u00034pY\u0012,'/\u00133\u0011\t\u0005]\u0011q\u0007\b\u0005\u00033\t\tD\u0004\u0003\u0002\u001c\u0005=b\u0002BA\u000f\u0003[qA!a\b\u0002,9!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#a\n\u000f\u0007Q\f)#C\u0001)\u0013\t1s%\u0003\u0002%K%\u00111iI\u0005\u0003E\u000eL!!Q1\n\t\u0005M\u0012QG\u0001\u0005\u0007&LEM\u0003\u0002BC&!\u0011\u0011HA\u001e\u0005\u0011\u0019\u0015.\u00133\u000b\t\u0005M\u0012Q\u0007\u0005\b\u0003\u007fQ\u0001\u0019AA!\u0003\u0019\u0019H/\u0019;fgB1\u0011\u0011AA\"\u0003\u000fJA!!\u0012\u0002\u0010\t1a+Z2u_J\u0004B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0004fm\u0016tGo\u001d\u0006\u0004\u0003#\n\u0013aB<fE\"|wn[\u0005\u0005\u0003+\nYEA\u000bEKBdw._7f]R\u001cVM\u001d<fe\u00163XM\u001c;\u0002/M\fg/Z(s+B$\u0017\r^3Ti\u0006$Xo]#wK:$H\u0003CA.\u0003/\u000bI*!(\u0015\r\u0005u\u0013\u0011OAF!\u0015a\u0013qLA2\u0013\r\t\t'\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u0014QN\u0007\u0003\u0003OR1aSA5\u0015\r\tYgI\u0001\u0007I>l\u0017-\u001b8\n\t\u0005=\u0014q\r\u0002\u000f\u0019&4X\rR3qY>LX.\u001a8u\u0011%\t\u0019h\u0003I\u0001\u0002\b\t)(\u0001\u0003f]Z\u001c\bcBA<\u0003\u0003\u000b\u0018QQ\u0007\u0003\u0003sRA!a\u001f\u0002~\u00059Q.\u001e;bE2,'bAA@[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BA3\u0003\u000fKA!!#\u0002h\tYQI\u001c<je>tW.\u001a8u\u0011%\tii\u0003I\u0001\u0002\b\ty)\u0001\u0003baB\u001c\bcBA<\u0003\u0003\u000b\u0018\u0011\u0013\t\u0005\u0003K\n\u0019*\u0003\u0003\u0002\u0016\u0006\u001d$aC!qa2L7-\u0019;j_:Dq!a\u0005\f\u0001\u0004\t)\u0002C\u0004\u0002\u001c.\u0001\r!a\u0012\u0002\u000b\u00154XM\u001c;\t\u000f\u0005}5\u00021\u0001\u0002\"\u0006aA-\u001a4bk2$8\u000b^1hKB!\u0011QMAR\u0013\u0011\t)+a\u001a\u0003!\u0015sg/\u001b:p]6,g\u000e^*uC\u001e,\u0017!I:bm\u0016|%/\u00169eCR,7\u000b^1ukN,e/\u001a8uI\u0011,g-Y;mi\u0012\"D\u0003CAV\u0003\u007f\u000b\t-a1+\t\u0005U\u0014QV\u0016\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011X\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0006M&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u00111\u0003\u0007A\u0002\u0005U\u0001bBAN\u0019\u0001\u0007\u0011q\t\u0005\b\u0003?c\u0001\u0019AAQ\u0003\u0005\u001a\u0018M^3PeV\u0003H-\u0019;f'R\fG/^:Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136)!\tI-a3\u0002N\u0006='\u0006BAH\u0003[Cq!a\u0005\u000e\u0001\u0004\t)\u0002C\u0004\u0002\u001c6\u0001\r!a\u0012\t\u000f\u0005}U\u00021\u0001\u0002\"\u0006\u0011\"/\u001a4sKNDWI\u001c<je>tW.\u001a8u)\u0019\t))!6\u0002Z\"9\u0011q\u001b\bA\u0002\u0005\u0015\u0015\u0001C8sS\u001eLg.\u00197\t\u000f\u0005mg\u00021\u0001\u0002H\u00051Q\u000f\u001d3bi\u0016\f!C]3ge\u0016\u001c\b.\u00119qY&\u001c\u0017\r^5p]RA\u0011\u0011SAq\u0003G\f)\u000fC\u0004\u0002X>\u0001\r!!%\t\u000f\u0005mw\u00021\u0001\u0002H!9\u0011q]\bA\u0002\u0005\u0015\u0015aB<ji\",eN^\u0001\u000eg\u00064X-\u00118e\u001d>$\u0018NZ=\u0015\r\u00055\u00181_A{!\ra\u0013q^\u0005\u0004\u0003cl#\u0001B+oSRDa!a\u0005\u0011\u0001\u0004\t\bbBA|!\u0001\u0007\u0011qI\u0001\u0018Kb$XM\u001d8bY\u0012+\u0007\u000f\\8z[\u0016tG/\u0012<f]R\fABZ5oI>sgi\u001c7eKJ$b\"!@\u0003\u0014\tU!q\u0004B\u0012\u0005w\u0011)\u0005\u0005\u0004\u0002\u0000\n=\u00111M\u0007\u0003\u0005\u0003QA!a\u001b\u0003\u0004)!!Q\u0001B\u0004\u0003\u0011!\u0017\r^1\u000b\t\t%!1B\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011!QB\u0001\u0004_J<\u0017\u0002\u0002B\t\u0005\u0003\u0011A\u0001U1hK\"9\u00111C\tA\u0002\u0005U\u0001b\u0002B\f#\u0001\u0007!\u0011D\u0001\u0006Y&l\u0017\u000e\u001e\t\u0004Y\tm\u0011b\u0001B\u000f[\t\u0019\u0011J\u001c;\t\u000f\t\u0005\u0012\u00031\u0001\u0003\u001a\u0005!\u0001/Y4f\u0011\u001d\u0011)#\u0005a\u0001\u0005O\tqa\u001c:eKJ\u0014\u0015\u0010\u0005\u0003\u0003*\t]RB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u000bYLWm^:\u000b\t\tE\"1G\u0001\tS:$XM\u001d8bY*\u0019!QG\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003:\t-\"a\u0006'jm\u0016$U\r\u001d7ps6,g\u000e^(sI\u0016\u0014Xj\u001c3f\u0011\u001d\u0011i$\u0005a\u0001\u0005\u007f\t\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u0011\t\t%\"\u0011I\u0005\u0005\u0005\u0007\u0012YC\u0001\u000fMSZ,G)\u001a9m_flWM\u001c;Pe\u0012,'\u000fR5sK\u000e$\u0018n\u001c8\t\u0011\t\u001d\u0013\u0003%AA\u0002E\f\u0011bY8oI&$\u0018n\u001c8\u0002\r\u0015D\u0018n\u001d;t)\u0019\u0011iEa\u0015\u0003VA\u0019AFa\u0014\n\u0007\tESFA\u0004C_>dW-\u00198\t\u000f\u0005M!\u00031\u0001\u0002\u0016!9!q\u000b\nA\u0002\te\u0013AB7bq\u0006;W\rE\u0002-\u00057J1A!\u0018.\u0005\u0011auN\\4\u0002!Q|G*\u001b<f\t\u0016\u0004Hn\\=nK:$H\u0003\u0002B2\u0005[\"b!a\u0019\u0003f\t%\u0004b\u0002B4'\u0001\u000f\u0011QO\u0001\tK:48)Y2iK\"9!1N\nA\u0004\u0005=\u0015\u0001C1qa\u000e\u000b7\r[3\t\u000f\t=4\u00031\u0001\u0003r\u0005\u0019!o\\<\u0011\t\tM$qO\u0007\u0003\u0005kR1A!\u0002A\u0013\u0011\u0011IH!\u001e\u0003#1Kg/\u001a#fa2|\u00170\\3oiJ{w\u000f\u0006\u0007\u0002d\tu$q\u0010BB\u0005\u000f\u0013Y\tC\u0004\u0002\u0014Q\u0001\r!!\u0006\t\u000f\t\u0005E\u00031\u0001\u0002\u0016\u0005iQM^3oiN{WO]2f\u0013\u0012DqA!\"\u0015\u0001\u0004\t\t*A\u0006baBd\u0017nY1uS>t\u0007b\u0002BE)\u0001\u0007\u0011QQ\u0001\fK:4\u0018N]8o[\u0016tG\u000fC\u0004\u0003\u000eR\u0001\rAa$\u0002\u000bM$\u0018\r^3\u0011\t\u0005\u0015$\u0011S\u0005\u0005\u0005'\u000b9GA\bEKBdw._7f]R\u001cF/\u0019;f\u0003Q\u0019wN\\:ueV\u001cG/\u00119qY&\u001c\u0017\r^5p]RA\u0011\u0011\u0013BM\u00057\u0013i\n\u0003\u0004\u0002\u0014U\u0001\r!\u001d\u0005\b\u00037+\u0002\u0019AA$\u0011\u001d\u0011I)\u0006a\u0001\u0003\u000b\u000bAcY8ogR\u0014Xo\u0019;F]ZL'o\u001c8nK:$H\u0003CAC\u0005G\u0013)Ka*\t\u000f\u0005Ma\u00031\u0001\u0002\u0016!9\u00111\u0014\fA\u0002\u0005\u001d\u0003b\u0002BU-\u0001\u0007\u0011\u0011U\u0001\u0006gR\fw-Z\u0001\u0012M\u0016$8\r\u001b#fM\u0006,H\u000e^*uC\u001e,WCAAQ\u0003\u0015\u0019w.\u001e8u)\u0019\u0011\u0019La1\u0003FB!!Q\u0017B`\u001b\t\u00119L\u0003\u0003\u0003:\nm\u0016\u0001\u00027b]\u001eT!A!0\u0002\t)\fg/Y\u0005\u0005\u0005\u0003\u00149LA\u0004J]R,w-\u001a:\t\u000f\u0005M\u0001\u00041\u0001\u0002\u0016!1!q\t\rA\u0002E\faC]3n_Z,7\u000b^1mK\u0012+\u0007\u000f\\8z[\u0016tGo\u001d\u000b\u0007\u0003[\u0014YM!4\t\r\t\u0005\u0015\u00041\u0001r\u0011!\u0011y-\u0007I\u0001\u0002\u0004y\u0018aB3yG2,H-Z\u0001\u0007g\u0016\f'o\u00195\u0015\t\tU'q\u001b\t\u0007\u0003\u0003\tY!a\u0019\t\u000f\te'\u00041\u0001\u0003\\\u0006)B.\u001b<f\t\u0016\u0004Hn\\=nK:$h)\u001b7uKJ\u001c\b\u0003\u0002Bo\u0005Gl!Aa8\u000b\t\t\u0005(qF\u0001\u0007M&dG/\u001a:\n\t\t\u0015(q\u001c\u0002\u0016\u0019&4X\rR3qY>LX.\u001a8u\r&dG/\u001a:t\u0003I1\u0017N\u001c3Cs\u0012+\u0007\u000f\\8z[\u0016tG/\u00133\u0015\t\u0005\r$1\u001e\u0005\u0007\u0005[\\\u0002\u0019A9\u0002\u0019\u0011,\u0007\u000f\\8z[\u0016tG/\u00133\u0002%M,\u0017M]2i\u000b:4\u0018N]8o[\u0016tGo\u001d\u000b\u0005\u0005g\u0014)\u0010\u0005\u0004\u0002\u0002\u0005-\u0011Q\u0011\u0005\b\u00053d\u0002\u0019\u0001Bn\u0003I\u0019X-\u0019:dQ\u0006\u0003\b\u000f\\5dCRLwN\\:\u0015\t\tm(Q \t\u0007\u0003\u0003\tY!!%\t\u000f\teW\u00041\u0001\u0003\\\"\u001a\u0001a!\u0001\u0011\t\r\r1\u0011B\u0007\u0003\u0007\u000bQAaa\u0002\u0003\b\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\r-1Q\u0001\u0002\b'\u0016\u0014h/[2fQ\r\u00011q\u0002\t\u0005\u0007#\u0019i\"\u0004\u0002\u0004\u0014)!1QCB\f\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007\t\u001cIBC\u0002\u0004\u001c\r\n!\u0001\u001a2\n\t\r}11\u0003\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class LiveDeploymentServiceImpl
implements LiveDeploymentService,
Logging {
    private final LiveDeploymentPersistence deploymentPersistence;
    private final ApplicationRepository applicationRepository;
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentStageRepository environmentStageRepository;
    private final ServerSentEventsService serverSentEventsService;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final String DefaultUnknown;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public String findOnFolder$default$6() {
        return LiveDeploymentService.findOnFolder$default$6$(this);
    }

    @Override
    public List<String> removeStaleDeployments$default$2() {
        return LiveDeploymentService.removeStaleDeployments$default$2$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LiveDeploymentServiceImpl liveDeploymentServiceImpl = this;
        synchronized (liveDeploymentServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private String DefaultUnknown() {
        return this.DefaultUnknown;
    }

    @Override
    public List<String> batchSaveOrUpdate(String folderId, Vector<DeploymentServerEvent> states) {
        Map envs = (Map)Map$.MODULE$.empty();
        Map apps = (Map)Map$.MODULE$.empty();
        return ((IterableOnceOps)states.flatMap((Function1 & Serializable)state -> this.saveOrUpdateStatusEvent(folderId, (DeploymentServerEvent)((Object)state), this.fetchDefaultStage(), (Map<String, Environment>)envs, (Map<String, Application>)apps).map((Function1 & Serializable)x$1 -> x$1.getId()))).toList();
    }

    private Option<LiveDeployment> saveOrUpdateStatusEvent(String folderId, DeploymentServerEvent event, EnvironmentStage defaultStage, Map<String, Environment> envs, Map<String, Application> apps) {
        Environment env = (Environment)envs.getOrElseUpdate((Object)event.environmentCuid(), (Function0 & Serializable)() -> {
            Option envMaybe = $this.environmentRepository.findInFolderByCorrelationId(folderId, event.environmentCuid());
            return (Environment)envMaybe.map((Function1 & Serializable)existingEnv -> this.refreshEnvironment((Environment)existingEnv, event)).getOrElse((Function0 & Serializable)() -> $this.environmentRepository.createEnvironment(this.constructEnvironment(folderId, event, defaultStage)));
        });
        Application app = (Application)apps.getOrElseUpdate((Object)event.applicationCuid(), (Function0 & Serializable)() -> {
            Option appMaybe = $this.applicationRepository.findInFolderByCorrelationId(folderId, event.applicationCuid());
            return (Application)appMaybe.map((Function1 & Serializable)existingApp -> this.refreshApplication((Application)existingApp, event, env)).getOrElse((Function0 & Serializable)() -> $this.applicationRepository.createApplication(this.constructApplication(folderId, event, env)));
        });
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.deploymentPersistence.save(this.toLiveDeployment(folderId, event.configId(), app, env, event.deploymentState())));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Couldn't save fetched external deployment for Endpoint [" + folderId + "] into database, skipping record: " + exception.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> exception);
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            LiveDeploymentRow row = (LiveDeploymentRow)success.value();
            return new Some((Object)this.toLiveDeployment(row, envs, apps));
        }
        throw new MatchError((Object)try_);
    }

    private Map<String, Environment> saveOrUpdateStatusEvent$default$4(String folderId, DeploymentServerEvent event, EnvironmentStage defaultStage) {
        return (Map)Map$.MODULE$.empty();
    }

    private Map<String, Application> saveOrUpdateStatusEvent$default$5(String folderId, DeploymentServerEvent event, EnvironmentStage defaultStage) {
        return (Map)Map$.MODULE$.empty();
    }

    private Environment refreshEnvironment(Environment original, DeploymentServerEvent update) {
        boolean dirty = false;
        if (original == null || update == null) {
            return original;
        }
        String string = original.getTitle();
        String string2 = update.environmentTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            original.setTitle(update.environmentTitle());
            dirty = true;
        }
        DeploymentTarget originalTarget = original.getDeploymentTarget();
        DeploymentTarget updateTarget = update.deploymentTarget();
        if (originalTarget != null && updateTarget == null) {
            original.setDeploymentTarget(null);
            dirty = true;
        }
        if (updateTarget != null) {
            original.setDeploymentTarget(updateTarget);
            dirty = true;
        }
        if (dirty) {
            return this.environmentRepository.updateEnvironment(original);
        }
        return original;
    }

    public Application refreshApplication(Application original, DeploymentServerEvent update, Environment withEnv) {
        Buffer containedEnvCorrelationIds;
        boolean dirty = false;
        if (original == null || update == null) {
            return original;
        }
        String string = original.getTitle();
        String string2 = update.applicationTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            original.setTitle(update.applicationTitle());
            dirty = true;
        }
        if (!(containedEnvCorrelationIds = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(original.getEnvironments()).asScala().map((Function1 & Serializable)e -> e.getCorrelationUid())).contains((Object)withEnv.getCorrelationUid())) {
            original.getEnvironments().add(withEnv);
            dirty = true;
        }
        ApplicationSource originalSource = original.getApplicationSource();
        ApplicationSource updateSource = update.applicationSource();
        if (originalSource != null && updateSource == null) {
            original.setApplicationSource(null);
            dirty = true;
        }
        if (updateSource != null) {
            original.setApplicationSource(updateSource);
            dirty = true;
        }
        if (dirty) {
            return this.applicationRepository.updateApplication(original);
        }
        return original;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void saveAndNotify(String folderId, DeploymentServerEvent externalDeploymentEvent) {
        block9: {
            block8: {
                var5_3 = externalDeploymentEvent;
                if (var5_3 == null) break block8;
                var6_4 = var5_3;
                v0 = var6_4.operation();
                var7_5 = "remove";
                if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block8;
                env = (Environment)this.environmentRepository.findInFolderByCorrelationId(folderId, externalDeploymentEvent.environmentCuid()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$1(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Lscala/runtime/Nothing$;)((DeploymentServerEvent)externalDeploymentEvent));
                app = (Application)this.applicationRepository.findInFolderByCorrelationId(folderId, externalDeploymentEvent.applicationCuid()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$2(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Lscala/runtime/Nothing$;)((DeploymentServerEvent)externalDeploymentEvent));
                liveDeploymentId = this.deploymentPersistence.fetchLiveDeploymentId(folderId, app.getId(), env.getId());
                v1 = liveDeploymentId.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAndNotify$3(com.xebialabs.xlrelease.status.service.LiveDeploymentServiceImpl java.lang.String ), (Ljava/lang/String;)Lcom/xebialabs/xlrelease/status/webhook/events/DeleteLiveDeploymentEvent;)((LiveDeploymentServiceImpl)this));
                break block9;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            var11_9 = var5_3;
            v2 = var11_9.operation();
            var12_10 = "create";
            if (!(v2 != null ? v2.equals(var12_10) == false : var12_10 != null) && Option$.MODULE$.apply((Object)var11_9.deploymentState()).exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAndNotify$4$adapted(com.xebialabs.xlrelease.domain.environments.DeploymentState ), (Lcom/xebialabs/xlrelease/domain/environments/DeploymentState;)Ljava/lang/Object;)())) {
                this.debug((Function0<Object>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$5(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Ljava/lang/String;)((DeploymentServerEvent)externalDeploymentEvent));
                v1 = new Some((Object)new CreateLiveDeploymentEvent());
            } else if (var5_3 != null && Option$.MODULE$.apply((Object)(var13_11 = var5_3).deploymentState()).exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAndNotify$6$adapted(com.xebialabs.xlrelease.domain.environments.DeploymentState ), (Lcom/xebialabs/xlrelease/domain/environments/DeploymentState;)Ljava/lang/Object;)())) {
                x$1 = folderId;
                x$2 = var13_11;
                x$3 = this.fetchDefaultStage();
                x$4 = this.saveOrUpdateStatusEvent$default$4(x$1, x$2, x$3);
                x$5 = this.saveOrUpdateStatusEvent$default$5(x$1, x$2, x$3);
                deployment = this.saveOrUpdateStatusEvent(x$1, x$2, x$3, x$4, x$5);
                v1 = deployment.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAndNotify$7(com.xebialabs.xlrelease.domain.environments.LiveDeployment ), (Lcom/xebialabs/xlrelease/domain/environments/LiveDeployment;)Lcom/xebialabs/xlrelease/status/webhook/events/UpdateLiveDeploymentEvent;)());
            } else if (var5_3 != null && Option$.MODULE$.apply((Object)(var20_18 = var5_3).environmentCuid()).isEmpty()) {
                this.info((Function0<Object>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$8(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Ljava/lang/String;)((DeploymentServerEvent)var20_18));
                v1 = None$.MODULE$;
            } else if (var5_3 != null) {
                var21_19 = var5_3;
                this.info((Function0<Object>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$10(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Ljava/lang/String;)((DeploymentServerEvent)var21_19));
                v1 = None$.MODULE$;
            } else {
                this.warn((Function0<Object>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAndNotify$13(com.xebialabs.xlrelease.status.webhook.events.DeploymentServerEvent ), ()Ljava/lang/String;)((DeploymentServerEvent)var5_3));
                v1 = None$.MODULE$;
            }
        }
        event = v1;
        event.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAndNotify$14$adapted(com.xebialabs.xlrelease.status.service.LiveDeploymentServiceImpl com.xebialabs.xlrelease.status.webhook.events.LiveDeploymentEvent ), (Lcom/xebialabs/xlrelease/status/webhook/events/LiveDeploymentEvent;)Ljava/lang/Object;)((LiveDeploymentServiceImpl)this));
    }

    @Override
    public Page<LiveDeployment> findOnFolder(String folderId, int limit, int page, LiveDeploymentOrderMode orderBy, LiveDeploymentOrderDirection direction, String condition) {
        Map envCache = (Map)Map$.MODULE$.empty();
        Map appCache = (Map)Map$.MODULE$.empty();
        Vector results = (Vector)this.deploymentPersistence.findOnFolder(folderId, limit, limit * page, orderBy, direction, condition).map((Function1 & Serializable)row -> this.toLiveDeployment((LiveDeploymentRow)row, (Map<String, Environment>)envCache, (Map<String, Application>)appCache));
        int totalCount = this.deploymentPersistence.count(folderId, condition);
        PageRequest pageable = PageRequest.of((int)page, (int)limit, (Sort.Direction)LiveDeploymentOrderDirection.toDirection(direction), (String[])new String[]{orderBy.toString()});
        return new ReleasePageImpl(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)results).asJava(), (Pageable)pageable, (long)totalCount);
    }

    @Override
    public boolean exists(String folderId, long maxAge) {
        return this.deploymentPersistence.exists(folderId, maxAge);
    }

    private LiveDeployment toLiveDeployment(LiveDeploymentRow row, Map<String, Environment> envCache, Map<String, Application> appCache) {
        LiveDeployment ci = (LiveDeployment)CiSerializerHelper$.MODULE$.deserialize(row.json(), (Repository)this.repositoryAdapter);
        ci.setFolderId(row.folderId());
        Environment env = (Environment)envCache.getOrElseUpdate((Object)ci.getEnvironment().getId(), (Function0 & Serializable)() -> $this.environmentRepository.findEnvironmentById(ci.getEnvironment().getId()));
        Application app = (Application)appCache.getOrElseUpdate((Object)ci.getApplication().getId(), (Function0 & Serializable)() -> $this.applicationRepository.findApplicationById(ci.getApplication().getId()));
        ci.setEnvironment(env);
        ci.setApplication(app);
        return ci;
    }

    private LiveDeployment toLiveDeployment(String folderId, String eventSourceId, Application application, Environment environment, DeploymentState state) {
        return LiveDeployment.create((String)folderId, (String)eventSourceId, (Application)application, (Environment)environment, (DeploymentState)state);
    }

    private Application constructApplication(String folderId, DeploymentServerEvent event, Environment environment) {
        Application application = new Application();
        application.setId(null);
        application.setTitle(event.applicationTitle());
        application.setApplicationSource(event.applicationSource());
        application.setCorrelationUid(event.applicationCuid());
        application.setFolderId(folderId);
        application.setEnvironments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)environment, (List)Nil$.MODULE$)).asJava());
        return application;
    }

    private Environment constructEnvironment(String folderId, DeploymentServerEvent event, EnvironmentStage stage) {
        Environment environment = new Environment();
        environment.setId(null);
        environment.setTitle(event.environmentTitle());
        environment.setCorrelationUid(event.environmentCuid());
        environment.setDeploymentTarget(event.deploymentTarget());
        environment.setFolderId(folderId);
        environment.setStage(stage);
        return environment;
    }

    private EnvironmentStage fetchDefaultStage() {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.environmentStageRepository.findByTitle(this.DefaultUnknown()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            EnvironmentStage stage = (EnvironmentStage)success.value();
            return stage;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                return this.environmentStageRepository.create(EnvironmentStage.create((String)this.DefaultUnknown()));
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Integer count(String folderId, String condition) {
        return Predef$.MODULE$.int2Integer(this.deploymentPersistence.count(folderId, condition));
    }

    @Override
    public void removeStaleDeployments(String eventSourceId, List<String> exclude) {
        this.deploymentPersistence.deleteByEventSourceIdAndDeploymentIdNotIn(eventSourceId, exclude);
    }

    @Override
    public List<LiveDeployment> search(LiveDeploymentFilters liveDeploymentFilters) {
        Map envs = (Map)Map$.MODULE$.empty();
        Map apps = (Map)Map$.MODULE$.empty();
        return ((IterableOnceOps)this.deploymentPersistence.search(liveDeploymentFilters).map((Function1 & Serializable)row -> this.toLiveDeployment((LiveDeploymentRow)row, (Map<String, Environment>)envs, (Map<String, Application>)apps))).toList();
    }

    @Override
    public LiveDeployment findByDeploymentId(String deploymentId) {
        Map envs = (Map)Map$.MODULE$.empty();
        Map apps = (Map)Map$.MODULE$.empty();
        return (LiveDeployment)this.deploymentPersistence.findByDeploymentId(deploymentId).map((Function1 & Serializable)row -> this.toLiveDeployment((LiveDeploymentRow)row, (Map<String, Environment>)envs, (Map<String, Application>)apps)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Couldn't find LiveDeployment with id " + deploymentId, new Object[0]);
        });
    }

    @Override
    public List<Environment> searchEnvironments(LiveDeploymentFilters liveDeploymentFilters) {
        Map cachedStages = (Map)Map$.MODULE$.empty();
        Map cachedLabels = (Map)Map$.MODULE$.empty();
        EnvironmentLabelRepository environmentLabelRepository = null;
        EnvironmentStageRepository environmentStageRepository = this.environmentStageRepository;
        SqlRepositoryAdapter repositoryAdapter = this.repositoryAdapter;
        return ((IterableOnceOps)this.deploymentPersistence.searchEnvironments(liveDeploymentFilters).map((Function1 & Serializable)row -> {
            RowWithContent x$1 = row;
            EnvironmentStageRepository x$2 = environmentStageRepository;
            EnvironmentLabelRepository x$3 = environmentLabelRepository;
            SqlRepositoryAdapter x$4 = repositoryAdapter;
            Map x$5 = cachedStages;
            Map x$6 = cachedLabels;
            Map x$7 = package$.MODULE$.mapEnvironmentContent$default$5(x$1);
            return package$.MODULE$.mapEnvironmentContent(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
        })).toList();
    }

    @Override
    public List<Application> searchApplications(LiveDeploymentFilters liveDeploymentFilters) {
        Map cachedStages = (Map)Map$.MODULE$.empty();
        Map cachedLabels = (Map)Map$.MODULE$.empty();
        EnvironmentLabelRepository environmentLabelRepository = null;
        EnvironmentStageRepository environmentStageRepository = this.environmentStageRepository;
        SqlRepositoryAdapter repositoryAdapter = this.repositoryAdapter;
        EnvironmentPersistence environmentPersistence = this.deploymentPersistence.environmentPersistence();
        return ((IterableOnceOps)this.deploymentPersistence.searchApplications(liveDeploymentFilters).map((Function1 & Serializable)row -> {
            RowWithContent x$1 = row;
            EnvironmentPersistence x$2 = environmentPersistence;
            EnvironmentStageRepository x$3 = environmentStageRepository;
            EnvironmentLabelRepository x$4 = environmentLabelRepository;
            SqlRepositoryAdapter x$5 = repositoryAdapter;
            Map x$6 = cachedStages;
            Map x$7 = cachedLabels;
            Map x$8 = package$.MODULE$.mapApplicationContent$default$6(x$1);
            Map x$9 = package$.MODULE$.mapApplicationContent$default$7(x$1);
            return package$.MODULE$.mapApplicationContent(x$1, x$2, x$3, x$4, x$5, x$8, x$9, x$6, x$7);
        })).toList();
    }

    public static final /* synthetic */ Nothing$ $anonfun$saveAndNotify$1(DeploymentServerEvent externalDeploymentEvent$1) {
        throw new NotFoundException("Couldn't find environment with correlation '" + externalDeploymentEvent$1.environmentCuid() + "'", new Object[0]);
    }

    public static final /* synthetic */ Nothing$ $anonfun$saveAndNotify$2(DeploymentServerEvent externalDeploymentEvent$1) {
        throw new NotFoundException("Couldn't find application with correlation '" + externalDeploymentEvent$1.applicationCuid() + "'", new Object[0]);
    }

    public static final /* synthetic */ DeleteLiveDeploymentEvent $anonfun$saveAndNotify$3(LiveDeploymentServiceImpl $this, String deploymentId) {
        $this.deploymentPersistence.delete(deploymentId);
        return new DeleteLiveDeploymentEvent(deploymentId);
    }

    public static final /* synthetic */ boolean $anonfun$saveAndNotify$4(DeploymentState s) {
        return Option$.MODULE$.apply((Object)s.getStatus()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$saveAndNotify$5(DeploymentServerEvent externalDeploymentEvent$1) {
        return "Received CreateStatusEvent [" + externalDeploymentEvent$1.applicationTitle() + " on " + externalDeploymentEvent$1.environmentTitle() + "] - refreshing live deployments.";
    }

    public static final /* synthetic */ boolean $anonfun$saveAndNotify$6(DeploymentState s) {
        return Option$.MODULE$.apply((Object)s.getStatus()).isDefined();
    }

    public static final /* synthetic */ UpdateLiveDeploymentEvent $anonfun$saveAndNotify$7(LiveDeployment d) {
        return new UpdateLiveDeploymentEvent(d.getId(), d);
    }

    public static final /* synthetic */ String $anonfun$saveAndNotify$8(DeploymentServerEvent x5$1) {
        return "Received `" + x5$1.getOperation() + "` event for creation of correlated application " + Option$.MODULE$.apply((Object)x5$1.applicationCuid()).getOrElse((Function0 & Serializable)() -> "-") + " - skipping status update.";
    }

    public static final /* synthetic */ String $anonfun$saveAndNotify$10(DeploymentServerEvent x6$1) {
        return "Received `" + x6$1.getOperation() + "` event for correlated application " + Option$.MODULE$.apply((Object)x6$1.applicationCuid()).getOrElse((Function0 & Serializable)() -> "-") + " on correlated environment " + Option$.MODULE$.apply((Object)x6$1.environmentCuid()).getOrElse((Function0 & Serializable)() -> "-") + " with no status - skipping update.";
    }

    public static final /* synthetic */ String $anonfun$saveAndNotify$13(DeploymentServerEvent x1$1) {
        return "Couldn't execute ExternalDeploymentEvent[" + x1$1.getClass().getName() + "] persistence - skipping save to database.";
    }

    public LiveDeploymentServiceImpl(LiveDeploymentPersistence deploymentPersistence, ApplicationRepository applicationRepository, EnvironmentRepository environmentRepository, EnvironmentStageRepository environmentStageRepository, ServerSentEventsService serverSentEventsService, SqlRepositoryAdapter repositoryAdapter) {
        this.deploymentPersistence = deploymentPersistence;
        this.applicationRepository = applicationRepository;
        this.environmentRepository = environmentRepository;
        this.environmentStageRepository = environmentStageRepository;
        this.serverSentEventsService = serverSentEventsService;
        this.repositoryAdapter = repositoryAdapter;
        Logging.$init$((Logging)this);
        this.DefaultUnknown = "Unknown";
    }

    public static final /* synthetic */ Object $anonfun$saveAndNotify$4$adapted(DeploymentState s) {
        return BoxesRunTime.boxToBoolean((boolean)LiveDeploymentServiceImpl.$anonfun$saveAndNotify$4(s));
    }

    public static final /* synthetic */ Object $anonfun$saveAndNotify$6$adapted(DeploymentState s) {
        return BoxesRunTime.boxToBoolean((boolean)LiveDeploymentServiceImpl.$anonfun$saveAndNotify$6(s));
    }

    public static final /* synthetic */ Object $anonfun$saveAndNotify$14$adapted(LiveDeploymentServiceImpl $this, LiveDeploymentEvent event) {
        $this.serverSentEventsService.send(event);
        return BoxedUnit.UNIT;
    }
}

