import React from 'react';

import { DotThemeProvider } from '@digital-ai/dot-components';
import './setup-deployment-server.component.less';
import { SetupDeploymentServer } from './setup-deployment-server.component';
import { DeploymentServerDrawer } from './deployment-server-drawer.component';
import { DEFAULT_APPLICATION_SEARCH_CATEGORY } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/constants';
import { useAppDispatch } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { workflow } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';
import { folderDeploymentServers } from '../../ducks/deployment-server.reducer';
import { ONBOARD_APPLICATION_WORKFLOWS_TITLE } from '../../constants';

const { initCondenseViewDrawer } = workflow.actions;
const { initDrawer } = folderDeploymentServers.actions;

interface SetupDeploymentPageComponentProps {
    folderId: string;
}

export const SetupDeploymentPageComponent = ({ folderId }: SetupDeploymentPageComponentProps) => {
    const dispatch = useAppDispatch();

    const onOnboard = () => {
        dispatch(
            initCondenseViewDrawer({
                catalogTitle: ONBOARD_APPLICATION_WORKFLOWS_TITLE,
                workflowSearch: { categories: [DEFAULT_APPLICATION_SEARCH_CATEGORY] },
            }),
        );
    };

    const onConnect = () => {
        dispatch(initDrawer({ folderId }));
    };

    return (
        <DotThemeProvider>
            <SetupDeploymentServer onConnect={onConnect} onOnboard={onOnboard} />
            <DeploymentServerDrawer folderId={folderId} />
        </DotThemeProvider>
    );
};
