import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationsTableComponentPortalProp, ExternalDeploymentComponentPortal } from './external-deployment-component.portal';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';

const { refreshExternalDeployments, setIsLiveDeploymentConfigurationOpen } = folderExternalDeployments.actions;

describe('ExternalDeploymentComponentPortal', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const mountComponent = (reSyncEnabled = false) => {
        const defaultProps: ApplicationsTableComponentPortalProp = {
            folder: {
                id: 'id',
                title: 'title',
            },
            reSyncEnabled,
        };
        wrapper = mountWithStoreAndTheme(<ExternalDeploymentComponentPortal {...defaultProps} />, dispatch);
    };

    const getFirstChildFromActionToolbarPortal = (): ReactElement => {
        const actionToolbarPortal = wrapper.find(ActionToolbarPortalContainer);
        return React.Children.toArray(actionToolbarPortal.props().children)[0] as ReactElement;
    };

    const getSecondChildFromActionToolbarPortal = (): ReactElement => {
        const actionToolbarPortal = wrapper.find(ActionToolbarPortalContainer);
        return React.Children.toArray(actionToolbarPortal.props().children)[1] as ReactElement;
    };

    it('should render portal properly', () => {
        mountComponent();

        const resyncButton = getFirstChildFromActionToolbarPortal();
        expect(resyncButton.type).toBe(DotButton);
        expect(resyncButton.props.disabled).toBe(true);
        expect(resyncButton.props.startIcon.type).toBe(DotIcon);
        expect(resyncButton.props.startIcon.props.iconId).toBe('sync');
        expect(resyncButton.props.type).toBe('outlined');
        expect(resyncButton.props.children).toBe('Re-sync');

        const configureButton = getSecondChildFromActionToolbarPortal();
        expect(configureButton.type).toBe(DotButton);
        expect(configureButton.props.disabled).toBeFalsy();
        expect(configureButton.props.startIcon).toBeFalsy();
        expect(configureButton.props.type).toBe('primary');
        expect(configureButton.props.children).toBe('Configure');
    });
    it('should click Re-sync', () => {
        mountComponent(true);
        const child = getFirstChildFromActionToolbarPortal();
        child.props.onClick();
        expect(dispatch).toHaveBeenCalledWith(refreshExternalDeployments());
    });
    it('Re-sync should be enabled', () => {
        mountComponent(true);
        const child = getFirstChildFromActionToolbarPortal();
        expect(child.props.disabled).toBe(false);
    });
    it('should click Configure', () => {
        mountComponent();
        const child = getSecondChildFromActionToolbarPortal();
        child.props.onClick();
        expect(dispatch).toHaveBeenCalledWith(setIsLiveDeploymentConfigurationOpen(true));
    });
});
