package com.xebialabs.xlrelease.status.webhook.events

import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.domain.environments.{Application, DeploymentState, Environment}
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer

import scala.beans.BeanProperty

@Metadata(virtual = false, label = "Status Webhook Request Event")
@JsonSerialize(using = classOf[CiSerializer])
class DeploymentProviderEvent extends Event {
  @BeanProperty
  @Property(label = "Operation")
  var operation: String = _

  @BeanProperty
  @Property(description = "Status Webhook Event Source Configuration ID associated with the deployment.")
  var configId: String = _

  @BeanProperty
  @Property(description = "Application reference associated with the deployment.", nested = true)
  var application: Application = _

  @BeanProperty
  @Property(description = "Environment reference associated with the deployment.", nested = true)
  var environment: Environment = _

  @BeanProperty
  @Property(description = "Current state of deployment", nested = true)
  @JsonSerialize(using = classOf[CiSerializer])
  var deploymentState: DeploymentState = _
}
