package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.v1.DeploymentProviderApi
import com.xebialabs.xlrelease.status.service.EndpointExternalDeploymentService
import com.xebialabs.xlrelease.views.AutoconfigResponse
import org.springframework.stereotype.Controller

@Controller
class DeploymentProviderApiImpl(externalDeploymentService: EndpointExternalDeploymentService) extends DeploymentProviderApi {

  override def autoconfigureDeploymentProvider(statusWebhookEventSourceId: String): AutoconfigResponse =
    externalDeploymentService.autoconfigureExternalDeployments(statusWebhookEventSourceId)

  override def patchDeploymentProvider(statusWebhookEventSourceId: String): Unit = {
    externalDeploymentService.patchExternalDeployments(statusWebhookEventSourceId)
  }
}
