import React, { ChangeEvent } from 'react';
import { ReactWrapper } from 'enzyme';
import { mountComponentWithStore } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { LiveDeploymentConfigurationTable } from './live-deployment-configuration-table.component';
import { Search } from '../../../../../../../../../../core/xlr-ui/app/react/components/search/search';
import { mockLiveDeploymentConfigData, pluginInfoDeploy } from '../../__mocks__/external-deployments.mocks';
import { DotTable } from '@digital-ai/dot-components';
import { folderExternalDeployments, FolderExternalDeploymentsState, initialPage, initialState } from '../../ducks/external-deployments.reducer';

const { setConfigurationFolderId, setConfigurationPage, setConfigurationCondition, loadLiveDeploymentsConfiguration } = folderExternalDeployments.actions;
const dispatch = jest.fn();
describe('LiveDeploymentConfigTable component', () => {
    let wrapper: ReactWrapper;
    const onViewChange = jest.fn();
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
        onViewChange,
    };

    const mountComponent = (state: FolderExternalDeploymentsState = initialState) => {
        wrapper = mountComponentWithStore(<LiveDeploymentConfigurationTable {...defaultProps} />, dispatch, {
            folderExternalDeployments: state,
        });
        expect(dispatch).toBeCalledWith(setConfigurationFolderId('folderId'));
        expect(dispatch).toBeCalledWith(loadLiveDeploymentsConfiguration());
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });
    const searchTable = (selector: string) => wrapper.find(`.live-deployment-configuration-table ${selector}`);

    it('should show the title, search box and table heading with no results', () => {
        expect(searchTable('h1.dot-typography').at(0).text()).toStrictEqual('Live deployments configuration');
        expect(searchTable('.search input').props().placeholder).toStrictEqual('Filter by values');
        expect(searchTable('p.dot-typography').at(0).text()).toStrictEqual('Name');
        expect(searchTable('p.dot-typography').at(1).text()).toStrictEqual('Connection');
        expect(searchTable('p.dot-typography').at(2).text()).toStrictEqual('Filter properties');
    });

    it('should trigger filter search', () => {
        jest.useFakeTimers();
        jest.spyOn(global, 'clearTimeout');
        jest.spyOn(global, 'setTimeout');
        const e1 = { target: { value: 'filter' } };
        wrapper.find(Search).invoke('onFilterChange')?.(e1 as unknown as ChangeEvent<HTMLInputElement>);
        wrapper.update();
        expect(setTimeout).toHaveBeenCalledTimes(1);
        expect(setTimeout).toHaveBeenLastCalledWith(expect.any(Function), 500);
        jest.runAllTimers();
        expect(dispatch).toHaveBeenCalledWith(setConfigurationCondition('filter'));
        expect(dispatch).toHaveBeenCalledWith(loadLiveDeploymentsConfiguration());
        const e2 = { target: { value: 'filter 2' } };
        wrapper.find(Search).invoke('onFilterChange')?.(e2 as unknown as ChangeEvent<HTMLInputElement>);
        wrapper.update();
        expect(clearTimeout).toHaveBeenCalledTimes(1);
        jest.runAllTimers();
        expect(dispatch).toHaveBeenCalledWith(setConfigurationCondition('filter 2'));
        expect(dispatch).toHaveBeenCalledWith(loadLiveDeploymentsConfiguration());
    });

    it('should not show one row and trigger page change', () => {
        mountComponent({
            ...initialState,
            liveDeploymentConfigsCount: 1,
            liveDeploymentConfigs: [mockLiveDeploymentConfigData],
        });
        expect(searchTable('.dot-tbody .empty-row').exists()).toBeFalsy();
        wrapper.find(DotTable).invoke('onUpdateData')?.('asc', 'column', 1, 10);
        expect(dispatch).toHaveBeenCalledWith(
            setConfigurationPage({
                ...initialPage,
                folderId: defaultProps.folder.id,
                order: 'asc',
                orderBy: 'column',
            }),
        );
        expect(dispatch).toHaveBeenCalledWith(loadLiveDeploymentsConfiguration());
    });

    it('should show rows when data available', () => {
        mountComponent({
            ...initialState,
            liveDeploymentConfigsCount: 1,
            liveDeploymentConfigs: [mockLiveDeploymentConfigData],
            validServerCards: [pluginInfoDeploy],
        });
        expect(searchTable('.dot-tbody .empty-row').exists()).toBeFalsy();
        expect(searchTable('.dot-table').exists()).toBeTruthy();
    });
});
