package com.xebialabs.xlrelease.api

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.api.v1.views.{ManagedApplicationPage, ManagedApplicationView}
import com.xebialabs.xlrelease.applications.management.service.{ApplicationsManagement, ManagedApplicationData}
import com.xebialabs.xlrelease.status.service._

import java.util.stream.Collectors
import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

package object internal {
  implicit def webhookSourceFiltersViewMapper(filters: WebhookSourceFilters): WebhookSourceFiltersView =
    WebhookSourceFiltersView.create(
      filters.webhookSourceId,
      filters.folderFilterOptions.asJava,
      filters.folderFilterValues.asJava
    )

  implicit def webhookQuickSetupViewMapper(webhookQuickSetup: WebhookBasicSetup): WebhookBasicSetupView =
    WebhookBasicSetupView.create(
      webhookQuickSetup.success,
      webhookQuickSetup.message,
      webhookQuickSetup.details,
      webhookQuickSetup.url,
      webhookQuickSetup.webhookSourceId
    )

  implicit def applicationsManagementViewMapper(applicationsManagement: ApplicationsManagement): ManagedApplicationPage =
    ManagedApplicationPage.create(
      applicationsManagement.totalCount,
      applicationsManagement.count,
      applicationsManagement.managedApplications.stream().map(managedApplicationViewMapper).collect(Collectors.toList()))

  implicit def managedApplicationViewMapper(managedApplication: ManagedApplicationData): ManagedApplicationView =
    ManagedApplicationView.create(
      managedApplication.id,
      managedApplication.applicationName,
      managedApplication.managedBy,
      managedApplication.dateCreated,
      managedApplication.environmentTag,
      managedApplication.applicationReference,
      null, //connectionServerViewMapper(managedApplication.connectionServer),
      managedApplication.workflowId,
      managedApplication.deleteWorkflowId,
      managedApplication.updateWorkflowId,
      managedApplication.folderId)

}
