import React, { useEffect } from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { FolderExternalDeploymentsProps } from '../../../external-deployments/components/folder-external-deployments';
import { ManagedApplicationTable } from './managed-application-table.component';
import { ApplicationsPageComponent } from '../applications-page/applications-page.component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getCreatedApplicationsTotalCountSelector } from '../../ducks/managed-application.selectors';
import { applicationManagement } from '../../ducks/managed-application.reducer';
import { DEFAULT_APPLICATION_SEARCH_CATEGORY } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/constants';
import { workflow } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

const { loadManagedApplications, getFilters } = applicationManagement.actions;
const { init } = workflow.actions;

export const ApplicationsPageWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const dispatch = useAppDispatch();

    useEffect(() => {
        if (folder) {
            dispatch(getFilters(folder.id));
            dispatch(loadManagedApplications());
        }
    }, [folder]);

    const dataSize = useAppSelector(getCreatedApplicationsTotalCountSelector);
    const hasAnyData = dataSize > 0;

    const openWorkflowDrawer = () => {
        dispatch(init({ categories: [DEFAULT_APPLICATION_SEARCH_CATEGORY] }));
    };

    const renderData = () => (
        <DotThemeProvider>
            {hasAnyData ? (
                <ManagedApplicationTable folder={folder} setCreateApplicationView={openWorkflowDrawer} />
            ) : (
                <ApplicationsPageComponent setCreateApplicationView={openWorkflowDrawer} />
            )}
        </DotThemeProvider>
    );

    return !folder ? <></> : renderData();
};
