import {
    APPLICATION_COLUMN_ID,
    APPLICATION_ORDER_BY,
    DESTINATION_COLUMN_ID,
    DESTINATION_ORDER_BY,
    STATUS_COLUMN_ID,
    STATUS_ORDER_BY,
    TIME_COLUMN_ID,
    TIME_ORDER_BY,
    VERSION_COLUMN_ID,
    VERSION_ORDER_BY,
} from '../constants';

export const mapOrderByValue = (columnName: string): string => {
    switch (columnName) {
        case APPLICATION_COLUMN_ID: {
            return APPLICATION_ORDER_BY;
        }
        case STATUS_COLUMN_ID: {
            return STATUS_ORDER_BY;
        }
        case DESTINATION_COLUMN_ID: {
            return DESTINATION_ORDER_BY;
        }
        case VERSION_COLUMN_ID: {
            return VERSION_ORDER_BY;
        }
        case TIME_COLUMN_ID: {
            return TIME_ORDER_BY;
        }
        default: {
            return STATUS_ORDER_BY;
        }
    }
};
