import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationsTableComponentPortalProp, ExternalDeploymentComponentPortal } from './external-deployment-component.portal';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';

const { refreshExternalDeployments } = folderExternalDeployments.actions;

describe('ExternalDeploymentComponentPortal', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const mountComponent = (reSyncEnabled = false) => {
        const defaultProps: ApplicationsTableComponentPortalProp = {
            folder: {
                id: 'id',
                title: 'title',
            },
            reSyncEnabled,
        };
        wrapper = mountWithStoreAndTheme(<ExternalDeploymentComponentPortal {...defaultProps} />, dispatch);
    };

    const getChildrenFromActionToolbarPortal = (): ReactElement => {
        const actionToolbarPortal = wrapper.find(ActionToolbarPortalContainer);
        return actionToolbarPortal.props().children as ReactElement;
    };

    it('should render portal properly', () => {
        mountComponent();
        const children = getChildrenFromActionToolbarPortal();
        expect(children.type).toBe(DotButton);
        expect(children.props.disabled).toBe(true);
        expect(children.props.startIcon.type).toBe(DotIcon);
        expect(children.props.startIcon.props.iconId).toBe('sync');
        expect(children.props.type).toBe('outlined');
        expect(children.props.children).toBe('Re-sync');
    });
    it('should click Re-sync', () => {
        mountComponent(true);
        const children = getChildrenFromActionToolbarPortal();
        children.props.onClick();
        expect(dispatch).toHaveBeenCalledWith(refreshExternalDeployments());
    });
    it('Re-sync should be enabled', () => {
        mountComponent(true);
        const children = getChildrenFromActionToolbarPortal();
        expect(children.props.disabled).toBe(false);
    });
});
