/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.status.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.environments.LiveDeploymentConfig;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.ConfigurationAutoconfigService;
import com.xebialabs.xlrelease.status.service.EndpointSetupDeploymentStatusService;
import com.xebialabs.xlrelease.status.service.WebhookBasicSetup;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource;
import com.xebialabs.xlrelease.views.AutoconfigResponse;
import com.xebialabs.xlrelease.webhooks.authentication.NoAuthentication;
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005y4A\u0001C\u0005\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!q\u0003A!A!\u0002\u0013y\u0003\"B\u001b\u0001\t\u00031\u0004\"B\u001e\u0001\t\u0003b\u0004\"\u0002.\u0001\t\u0013Y\u0006\"B3\u0001\t\u00131'!I*fiV\u0004\u0018\t\u001d9mS\u000e\fG/[8o'R\fG/^:TKJ4\u0018nY3J[Bd'B\u0001\u0006\f\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001D\u0007\u0002\rM$\u0018\r^;t\u0015\tqq\"A\u0005yYJ,G.Z1tK*\u0011\u0001#E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AE\u0001\u0004G>l7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\t\u0011\"\u0003\u0002\u001f\u0013\t!SI\u001c3q_&tGoU3ukB$U\r\u001d7ps6,g\u000e^*uCR,8oU3sm&\u001cW-\u0001\td_:4\u0017nZ;sCRLwN\\!qSB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003mFR!!J\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u0002(E\t\u00012i\u001c8gS\u001e,(/\u0019;j_:\f\u0005/[\u0001\u001fG>tg-[4ve\u0006$\u0018n\u001c8BkR|7m\u001c8gS\u001e\u001cVM\u001d<jG\u0016\u0004\"A\u000b\u0017\u000e\u0003-R!AC\u0007\n\u00055Z#AH\"p]\u001aLw-\u001e:bi&|g.Q;u_\u000e|gNZ5h'\u0016\u0014h/[2f\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u00023\u001b\u0005Q!/\u001a9pg&$xN]=\n\u0005Q\n$aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q!q\u0007O\u001d;!\ta\u0002\u0001C\u0003 \t\u0001\u0007\u0001\u0005C\u0003)\t\u0001\u0007\u0011\u0006C\u0003/\t\u0001\u0007q&A\u000ftKR,\b/\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t/\u0016\u0014\u0007n\\8l)\ri\u0004)\u0014\t\u00039yJ!aP\u0005\u0003#]+'\r[8pW\n\u000b7/[2TKR,\b\u000fC\u0003B\u000b\u0001\u0007!)\u0001\u0005d_:4\u0017nZ%e!\t\u0019%J\u0004\u0002E\u0011B\u0011QiF\u0007\u0002\r*\u0011qiE\u0001\u0007yI|w\u000e\u001e \n\u0005%;\u0012A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!S\f\t\u000b9+\u0001\u0019\u0001\"\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012D#!\u0002)\u0011\u0005ECV\"\u0001*\u000b\u0005M#\u0016a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0016,\u0002\u0007M\fHN\u0003\u0002X\u001b\u0005\u0011AMY\u0005\u00033J\u0013q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u001dGJ,\u0017\r^3IiR\u0004XI\u001c3q_&tGOR8s/\u0016\u0014\u0007n\\8l)\ra&m\u0019\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?6\ta\u0001Z8nC&t\u0017BA1_\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")aJ\u0002a\u0001\u0005\")AM\u0002a\u0001\u0005\u0006)A/\u001b;mK\u0006I2M]3bi\u0016\u001cF/\u0019;vg^+'\r[8pWN{WO]2f)\u0015av\r[5l\u0011\u0015qu\u00011\u0001C\u0011\u0015!w\u00011\u0001C\u0011\u0015Qw\u00011\u0001]\u0003-)g/\u001a8u'>,(oY3\t\u000b1<\u0001\u0019A7\u0002\r\r|gNZ5h!\tq\u0017/D\u0001p\u0015\t\u0001h,\u0001\u0007f]ZL'o\u001c8nK:$8/\u0003\u0002s_\n!B*\u001b<f\t\u0016\u0004Hn\\=nK:$8i\u001c8gS\u001eD#\u0001\u0001;\u0011\u0005UdX\"\u0001<\u000b\u0005]D\u0018AC:uKJ,w\u000e^=qK*\u0011\u0011P_\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t10A\u0002pe\u001eL!! <\u0003\u000fM+'O^5dK\u0002")
public class SetupApplicationStatusServiceImpl
implements EndpointSetupDeploymentStatusService {
    private final ConfigurationApi configurationApi;
    private final ConfigurationAutoconfigService configurationAutoconfigService;
    private final ConfigurationRepository configurationRepository;

    @Override
    @IsTransactional
    public WebhookBasicSetup setupApplicationStatusWebhook(String configId, String folderId) {
        LiveDeploymentConfig config = (LiveDeploymentConfig)this.configurationRepository.read(configId);
        StatusHttpConnection server = (StatusHttpConnection)config.getTargetServer();
        Configuration webhookEndpoint = this.createHttpEndpointForWebhook(folderId, server.getTitle());
        Configuration statusWebhookSource = this.createStatusWebhookSource(folderId, server.getTitle(), webhookEndpoint, config);
        AutoconfigResponse autoconfigResponse = this.configurationAutoconfigService.autoconfigure(statusWebhookSource);
        return new WebhookBasicSetup(Predef$.MODULE$.Boolean2boolean(autoconfigResponse.getSuccess()), autoconfigResponse.getMessage(), autoconfigResponse.getDetails(), autoconfigResponse.getUrl(), statusWebhookSource.getId());
    }

    private Configuration createHttpEndpointForWebhook(String folderId, String title) {
        WebhookEndpoint.PostWebhookEndpoint webhookEndpoint = (WebhookEndpoint.PostWebhookEndpoint)Type.valueOf(WebhookEndpoint.PostWebhookEndpoint.class).getDescriptor().newInstance("post-webhook-endpoint");
        webhookEndpoint.setTitle(title);
        webhookEndpoint.setFolderId(folderId);
        webhookEndpoint.setProperty("path", (Object)("path-" + UUID.randomUUID()));
        webhookEndpoint.setProperty("authentication", (Object)new NoAuthentication());
        return this.configurationApi.addConfiguration((Configuration)webhookEndpoint);
    }

    private Configuration createStatusWebhookSource(String folderId, String title, Configuration eventSource, LiveDeploymentConfig config) {
        String statusWebhookEventSourceType = ((StatusHttpConnection)config.getTargetServer()).getStatusWebhookEventSourceName();
        StatusWebhookEventSource statusWebhookEventSource = (StatusWebhookEventSource)Type.valueOf((String)statusWebhookEventSourceType).getDescriptor().newInstance("status-event-webhook");
        statusWebhookEventSource.setTitle(title);
        statusWebhookEventSource.setFolderId(folderId);
        statusWebhookEventSource.setProperty("eventSource", eventSource);
        statusWebhookEventSource.setProperty("config", config);
        return this.configurationApi.addConfiguration((Configuration)statusWebhookEventSource);
    }

    public SetupApplicationStatusServiceImpl(ConfigurationApi configurationApi, ConfigurationAutoconfigService configurationAutoconfigService, ConfigurationRepository configurationRepository) {
        this.configurationApi = configurationApi;
        this.configurationAutoconfigService = configurationAutoconfigService;
        this.configurationRepository = configurationRepository;
    }
}

