package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.domain.environments.LiveDeployment
import com.xebialabs.xlrelease.status.service.{EndpointExternalDeploymentService, EndpointSetupDeploymentStatusService}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import org.springframework.data.domain.Page
import org.springframework.stereotype.Controller

import java.{lang, util}
import scala.jdk.CollectionConverters._

@Controller
class ExternalDeploymentApiImpl(
                                 externalDeploymentService: EndpointExternalDeploymentService,
                                 setupDeploymentStatusService: EndpointSetupDeploymentStatusService,
                               ) extends ExternalDeploymentApi {
  override def getConnectionErrors(folderId: String, maxAge: lang.Long): util.Map[StatusHttpConnection, String] =
    externalDeploymentService.getConnectionErrors(folderId, maxAge).asJava

  override def getLiveDeployments(
                                   folderId: String,
                                   maxAge: lang.Long,
                                   page: lang.Integer,
                                   resultsPerPage: lang.Integer,
                                   orderBy: ExternalDeploymentOrderMode,
                                   direction: ExternalDeploymentOrderDirection,
                                   condition: String
                                 ): Page[LiveDeployment] =
    externalDeploymentService.getLiveDeployments(folderId, maxAge, page, resultsPerPage, orderBy, direction, condition)

  override def setupApplicationStatusWebhook(configId: String, folderId: String): WebhookBasicSetupView =
    setupDeploymentStatusService.setupApplicationStatusWebhook(configId, folderId)

  override def saveWebhookSourceFilters(webhookSourceId: String): StatusWebhookEventSource =
    externalDeploymentService.saveWebhookSourceFilters(webhookSourceId)

  override def deleteWebhook(webhookSourceId: String): Unit =
    externalDeploymentService.deleteWebhookSource(webhookSourceId)

  override def patchExternalDeployments(webhookSourceId: String): Unit =
    externalDeploymentService.patchExternalDeployments(webhookSourceId)

  override def countLiveDeployments(folderId: String, condition: String): Integer =
    externalDeploymentService.countLiveDeployments(folderId, condition)
}
