package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.status.service.{EndpointExternalDeploymentService, EndpointSetupDeploymentStatusService}
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import org.springframework.stereotype.Controller

import java.{lang, util}
import scala.jdk.CollectionConverters._

@Controller
class ExternalDeploymentApiImpl(
                                 externalDeploymentService: EndpointExternalDeploymentService,
                                 setupDeploymentStatusService: EndpointSetupDeploymentStatusService,
                               ) extends ExternalDeploymentApi {
  override def getExternalDeployments(
                                       folderId: String,
                                       maxAge: lang.Long,
                                       page: lang.Long,
                                       resultsPerPage: lang.Long,
                                       orderBy: ExternalDeploymentOrderMode,
                                       direction: ExternalDeploymentOrderDirection,
                                       condition: String
                                     ): ExternalDeploymentView = {
    externalDeploymentService.getExternalDeployment(folderId, maxAge, page, resultsPerPage, orderBy, direction, condition)
  }

  override def getWebhookSourceFilters(webhookSourceId: String): WebhookSourceFiltersView =
    externalDeploymentService.getWebhookSourceFilters(webhookSourceId)

  override def setupApplicationStatusWebhook(serverId: String, folderId: String): WebhookBasicSetupView =
    setupDeploymentStatusService.setupApplicationStatusWebhook(serverId, folderId)

  override def saveWebhookSourceFilters(webhookSourceId: String, filteredFolders: util.List[String]): StatusWebhookEventSource =
    externalDeploymentService.saveWebhookSourceFilters(webhookSourceId, filteredFolders.asScala.toList)

  override def deleteWebhook(webhookSourceId: String): Unit =
    externalDeploymentService.deleteWebhookSource(webhookSourceId)

  override def patchExternalDeployments(webhookSourceId: String): Unit =
    externalDeploymentService.patchExternalDeployments(webhookSourceId)
}
