import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountComponentWithStore } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderExternalDeploymentsWrapper } from './folder-external-deployments-wrapper.component';
import { ExternalDeploymentsTable } from './external-deployments-table.component';
import { initialState } from '../ducks/external-deployments.reducer';

describe('FolderExternalDeploymentsPage component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };
    const defaultState = {
        folderExternalDeployments: initialState,
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<FolderExternalDeploymentsWrapper {...defaultProps} />, dispatch, defaultState);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly and switch between the views', () => {
        const externalDeploymentsTable = wrapper.find(ExternalDeploymentsTable);
        expect(externalDeploymentsTable).toExist();
        expect(wrapper.find(ExternalDeploymentsTable)).toExist();
    });
});
