package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

@Component
class XLRelease243DeleteStatusWebhookEventSourcesUpgrade(configurationRepository: ConfigurationRepository) extends Upgrade with Logging {
  override def doUpgrade(): Boolean = {
    Try(removeExistingStatusWebhookEventSources()) match {
      case Success(_) => logger.info("Finished removing existing Status Webhook Event Sources")
      case Failure(_) => logger.error("Unable to remove existing Status Webhook Event Sources")
    }
    true
  }

  private def removeExistingStatusWebhookEventSources(): Unit = {
    configurationRepository.findAllByType[StatusWebhookEventSource](Type.valueOf(classOf[StatusWebhookEventSource])).asScala
      .foreach(s => {
        val endpointId = s.getEventSource.getId
        configurationRepository.delete(s.getId)
        configurationRepository.delete(endpointId)
      })
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.3.0#2")
}
