package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.domain.environments.LiveDeployment
import com.xebialabs.xlrelease.status.service.{EndpointExternalDeploymentService, EndpointSetupDeploymentStatusService}
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import org.springframework.data.domain.Page
import org.springframework.stereotype.Controller

import java.{lang, util}
import scala.jdk.CollectionConverters._

@Controller
class LiveDeploymentApiImpl(
                                 externalDeploymentService: EndpointExternalDeploymentService,
                                 setupDeploymentStatusService: EndpointSetupDeploymentStatusService,
                               ) extends LiveDeploymentApi {
  override def getConnectionErrors(folderId: String, maxAge: lang.Long): util.Map[StatusHttpConnection, String] =
    externalDeploymentService.getConnectionErrors(folderId, maxAge).asJava

  override def getLiveDeployments(
                                   folderId: String,
                                   maxAge: lang.Long,
                                   page: lang.Integer,
                                   resultsPerPage: lang.Integer,
                                   orderBy: LiveDeploymentOrderMode,
                                   direction: LiveDeploymentOrderDirection,
                                   condition: String
                                 ): Page[LiveDeployment] =
    externalDeploymentService.getLiveDeployments(folderId, maxAge, page, resultsPerPage, orderBy, direction, condition)

  override def setupApplicationStatusWebhook(folderId: String, serverId: String, configId: String): WebhookBasicSetupView =
    setupDeploymentStatusService.setupApplicationStatusWebhook(folderId, serverId, configId)

  override def saveWebhookSourceFilters(webhookSourceId: String): StatusWebhookEventSource =
    externalDeploymentService.saveWebhookSourceFilters(webhookSourceId)

  override def deleteWebhook(webhookSourceId: String): Unit =
    externalDeploymentService.deleteWebhookSource(webhookSourceId)

  override def patchExternalDeployments(webhookSourceId: String): Unit =
    externalDeploymentService.patchExternalDeployments(webhookSourceId)

  override def countLiveDeployments(folderId: String, condition: String): Integer =
    externalDeploymentService.countLiveDeployments(folderId, condition)

  override def getLiveDeploymentConfigs(
                                         folderId: String,
                                         page: Integer,
                                         resultsPerPage: Integer,
                                         orderBy: LiveDeploymentConfigOrderMode,
                                         direction: LiveDeploymentOrderDirection,
                                         condition: String
                                       ): Page[LiveDeploymentConfigView] =
    externalDeploymentService.getLiveDeploymentConfigs(folderId, page, resultsPerPage, orderBy, direction, condition)
}
