/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.applications.management.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.applications.management.repository.persistence.ApplicationsManagementPersistence;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagement;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplication;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplicationData;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.status.service.ConnectionServerData;
import com.xebialabs.xlrelease.status.service.EndpointExternalDeploymentService;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0007\u000f\u0001mA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001B\u0001B\u0003%a\bC\u0003F\u0001\u0011\u0005a\tC\u0003L\u0001\u0011\u0005C\nC\u0003l\u0001\u0011\u0005C\u000eC\u0003s\u0001\u0011%1\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003}\u0001\u0011\u0005S\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\u0011\u0001%\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4f[\u0016tGoU3sm&\u001cW-S7qY*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0006nC:\fw-Z7f]RT!a\u0005\u000b\u0002\u0019\u0005\u0004\b\u000f\\5dCRLwN\\:\u000b\u0005U1\u0012!\u0003=me\u0016dW-Y:f\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001a\u0005\u0003\u00019\t2\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$I5\ta\"\u0003\u0002&\u001d\ti\u0012\t\u001d9mS\u000e\fG/[8og6\u000bg.Y4f[\u0016tGoU3sm&\u001cW\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0015\u0003)\u0011X\r]8tSR|'/_\u0005\u0003iE\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002C\u0005\u0004\b\u000f\\5dCRLwN\\:NC:\fw-Z7f]R\u0004VM]:jgR,gnY3\u0011\u0005]ZT\"\u0001\u001d\u000b\u0005eR\u0014a\u00039feNL7\u000f^3oG\u0016T!A\r\t\n\u0005qB$!I!qa2L7-\u0019;j_:\u001cX*\u00198bO\u0016lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017!G3yi\u0016\u0014h.\u00197EKBdw._7f]R\u001cVM\u001d<jG\u0016\u0004\"aP\"\u000e\u0003\u0001S!aD!\u000b\u0005\t#\u0012AB:uCR,8/\u0003\u0002E\u0001\n\tSI\u001c3q_&tG/\u0012=uKJt\u0017\r\u001c#fa2|\u00170\\3oiN+'O^5dK\u00061A(\u001b8jiz\"Ba\u0012%J\u0015B\u00111\u0005\u0001\u0005\u0006]\u0011\u0001\ra\f\u0005\u0006k\u0011\u0001\rA\u000e\u0005\u0006{\u0011\u0001\rAP\u0001\u0017O\u0016$X*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogR)Q\nU/hSB\u00111ET\u0005\u0003\u001f:\u0011a#\u00119qY&\u001c\u0017\r^5p]Nl\u0015M\\1hK6,g\u000e\u001e\u0005\u0006#\u0016\u0001\rAU\u0001\tM>dG-\u001a:JIB\u00111K\u0017\b\u0003)b\u0003\"!\u0016\u0010\u000e\u0003YS!a\u0016\u000e\u0002\rq\u0012xn\u001c;?\u0013\tIf$\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-\u001f\u0011\u0015qV\u00011\u0001`\u0003\u0011\u0001\u0018mZ3\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n!Aj\u001c8h\u0011\u0015AW\u00011\u0001`\u00039\u0011Xm];miN\u0004VM\u001d)bO\u0016DqA[\u0003\u0011\u0002\u0003\u0007!+A\u0005d_:$\u0017\u000e^5p]\u0006)r-\u001a;NC:\fw-\u001a3BaBd\u0017nY1uS>tGCA7q!\t\u0019c.\u0003\u0002p\u001d\t1R*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8o\t\u0006$\u0018\rC\u0003r\r\u0001\u0007!+\u0001\u000bnC:\fw-\u001a3BaBd\u0017nY1uS>t\u0017\nZ\u0001\u0018M\u0016$8\r['b]\u0006<W\rZ!qa2L7-\u0019;j_:$\"\u0001^<\u0011\u0005\r*\u0018B\u0001<\u000f\u0005Ii\u0015M\\1hK\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\t\u000bE<\u0001\u0019\u0001*\u0002+\u0005$G-T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]R\u0011QN\u001f\u0005\u0006w\"\u0001\r\u0001^\u0001\u0013[\u0006t\u0017mZ3e\u0003B\u0004H.[2bi&|g.\u0001\rva\u0012\fG/Z'b]\u0006<W\rZ!qa2L7-\u0019;j_:$\"!\u001c@\t\u000bmL\u0001\u0019\u0001;\u00021\u0011,G.\u001a;f\u001b\u0006t\u0017mZ3e\u0003B\u0004H.[2bi&|g\u000e\u0006\u0003\u0002\u0004\u0005%\u0001cA\u000f\u0002\u0006%\u0019\u0011q\u0001\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006c*\u0001\rAU\u0001\u001bm\u0006d\u0017\u000eZ1uK6\u000bg.Y4fI\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0005\u0003\u0007\ty\u0001C\u0003|\u0017\u0001\u0007A/\u0001\u0016nC:\fw-\u001a3BaBd\u0017nY1uS>tGk\\'b]\u0006<W\rZ!qa2L7-\u0019;j_:$\u0015\r^1\u0015\u00075\f)\u0002C\u0003|\u0019\u0001\u0007A\u000fK\u0002\u0001\u00033\u0001B!a\u0007\u0002*5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a\t\u0002&\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002(\u0005\u0019qN]4\n\t\u0005-\u0012Q\u0004\u0002\b'\u0016\u0014h/[2f\u0001")
public class ApplicationManagementServiceImpl
implements ApplicationsManagementService,
Logging {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationsManagementPersistence applicationsManagementPersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public String getManagedApplications$default$4() {
        return ApplicationsManagementService.getManagedApplications$default$4$(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ApplicationManagementServiceImpl applicationManagementServiceImpl = this;
        synchronized (applicationManagementServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ApplicationsManagement getManagedApplications(String folderId, Long page, Long resultsPerPage, String condition) {
        int totalCount = this.applicationsManagementPersistence.countForFolder(folderId);
        int count = this.applicationsManagementPersistence.countForFolderWithCondition(folderId, condition);
        List managedApplications = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.applicationsManagementPersistence.findForFolder(folderId, Predef$.MODULE$.Long2long(resultsPerPage), Predef$.MODULE$.Long2long(resultsPerPage) * Predef$.MODULE$.Long2long(page), condition).map((Function1 & Serializable)ma -> this.managedApplicationToManagedApplicationData((ManagedApplication)ma))).asJava();
        return new ApplicationsManagement(totalCount, count, managedApplications);
    }

    @Override
    public ManagedApplicationData getManagedApplication(String managedApplicationId) {
        return this.managedApplicationToManagedApplicationData(this.fetchManagedApplication(managedApplicationId));
    }

    private ManagedApplication fetchManagedApplication(String managedApplicationId) {
        return (ManagedApplication)this.applicationsManagementPersistence.findById(managedApplicationId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Managed Application with id [" + managedApplicationId + "] not found", new Object[0]);
        });
    }

    @Override
    public ManagedApplicationData addManagedApplication(ManagedApplication managedApplication) {
        String managedApplicationId = this.applicationsManagementPersistence.create(managedApplication);
        ManagedApplication created = this.fetchManagedApplication(managedApplicationId);
        return this.managedApplicationToManagedApplicationData(created);
    }

    @Override
    public ManagedApplicationData updateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.id()), (String)"ID is required", (Object[])new Object[0]);
        this.validateManagedApplication(managedApplication);
        this.applicationsManagementPersistence.update(managedApplication);
        return this.managedApplicationToManagedApplicationData(managedApplication);
    }

    @Override
    public void deleteManagedApplication(String managedApplicationId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplicationId), (String)"ID is required", (Object[])new Object[0]);
        this.applicationsManagementPersistence.delete(managedApplicationId);
    }

    private void validateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.applicationName()), (String)"Application name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)managedApplication.connectionServer()).isDefined(), (String)"Connection server must be defined", (Object[])new Object[0]);
    }

    private ManagedApplicationData managedApplicationToManagedApplicationData(ManagedApplication managedApplication) {
        StatusHttpConnection connection = (StatusHttpConnection)this.configurationRepository.read(managedApplication.connectionServer());
        return new ManagedApplicationData(managedApplication.id(), managedApplication.applicationName(), managedApplication.managedBy(), managedApplication.dateCreated(), managedApplication.environmentTag(), managedApplication.applicationReference(), new ConnectionServerData(connection.getId(), connection.getTitle(), connection.getType().toString(), connection.getUrl(), (Option<String>)None$.MODULE$), managedApplication.workflowId(), managedApplication.deleteWorkflowId(), managedApplication.updateWorkflowId(), managedApplication.folderId());
    }

    public ApplicationManagementServiceImpl(ConfigurationRepository configurationRepository, ApplicationsManagementPersistence applicationsManagementPersistence, EndpointExternalDeploymentService externalDeploymentService) {
        this.configurationRepository = configurationRepository;
        this.applicationsManagementPersistence = applicationsManagementPersistence;
        Logging.$init$((Logging)this);
    }
}

