import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import './applications-page.component.less';

export interface ApplicationsPageProps {
    onViewChange: () => void;
    setCreateApplicationView: (_: boolean) => void;
}

export const ApplicationsPageComponent = ({ onViewChange, setCreateApplicationView }: ApplicationsPageProps) => {
    return (
        <div className="applications-placeholder">
            <div className="applications">
                <img alt="Applications" src={`static/@project.version@/include/applications-management/assets/applications.png`} width="300" />
                <div className="applications-title">Applications</div>
                <div className="applications-description">
                    Getting started with your applications. Create new applications in Argo CD or Digital.ai Deploy.
                    <div className="applications-buttons">
                        <DotButton data-testid="discover-btn" onClick={() => onViewChange()} type="outlined">
                            Discover applications
                        </DotButton>
                        <DotButton className="applications-create-btn" data-testid="create-btn" onClick={() => setCreateApplicationView(true)} type="primary">
                            Create application
                        </DotButton>
                    </div>
                </div>
            </div>
        </div>
    );
};
