import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { mountWithStoreAndTheme } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationsTableComponentPortalProp, ExternalDeploymentComponentPortal } from './external-deployment-component.portal';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';

const { refreshExternalDeployments } = folderExternalDeployments.actions;

describe('ExternalDeploymentComponentPortal', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const openApplicationSources = jest.fn();
    const onViewChange = jest.fn();
    const mountComponent = (reSyncEnabled = false) => {
        const defaultProps: ApplicationsTableComponentPortalProp = {
            folder: {
                id: 'id',
                title: 'title',
            },
            openApplicationSources,
            onViewChange,
            reSyncEnabled,
        };
        wrapper = mountWithStoreAndTheme(<ExternalDeploymentComponentPortal {...defaultProps} />, dispatch);
    };

    const getChildrenFromActionToolbarPortal = (): ReactElement[] => {
        const actionToolbarPortal = wrapper.find(ActionToolbarPortalContainer);
        return actionToolbarPortal.props().children as ReactElement[];
    };

    it('should render portal properly', () => {
        mountComponent();
        const children = getChildrenFromActionToolbarPortal();
        expect(children.length).toBe(3);
        expect(children[0].type).toBe(DotButton);
        expect(children[0].props.disabled).toBe(true);
        expect(children[0].props.startIcon.type).toBe(DotIcon);
        expect(children[0].props.startIcon.props.iconId).toBe('sync');
        expect(children[0].props.type).toBe('outlined');
        expect(children[0].props.children).toBe('Re-sync');
        expect(children[1].type).toBe(DotButton);
        expect(children[1].props.children).toBe('Discover applications');
    });
    it('should click Re-sync', () => {
        mountComponent(true);
        const children = getChildrenFromActionToolbarPortal();
        children[0].props.onClick();
        expect(dispatch).toHaveBeenCalledWith(refreshExternalDeployments());
    });
    it('should click Discover applications', () => {
        mountComponent();
        const children = getChildrenFromActionToolbarPortal();
        children[1].props.onClick();
        expect(onViewChange).toHaveBeenCalled();
    });
    it('Re-sync should be enabled', () => {
        mountComponent(true);
        const children = getChildrenFromActionToolbarPortal();
        expect(children[0].props.disabled).toBe(false);
    });
    it('should toggle menu on, select and leave', () => {
        mountComponent(true);
        const currentTarget = {};
        wrapper.update();
        const children = getChildrenFromActionToolbarPortal();
        children[2].props.children[0].props.onClick({ currentTarget });
        wrapper.update();
        const menu = getChildrenFromActionToolbarPortal()[2].props.children[1];
        expect(menu.props.open).toBe(true);
        expect(menu.props.anchorEl).toBe(currentTarget);
        menu.props.onSelect();
        wrapper.update();
        expect(openApplicationSources).toHaveBeenCalled();
        menu.props.onLeave();
        wrapper.update();
        expect(getChildrenFromActionToolbarPortal()[2].props.children[1].props.open).toBe(false);
    });
});
