package com.xebialabs.xlrelease.status.service.script

import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.status.webhook.events.{StatusWebhookEvent, StatusWebhookEventSource}
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.stereotype.Component

trait MapScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource, event: Event): Event
}

@Component
class MapScriptExecutor(
                         runnerScriptService: RunnerScriptService
                          ) extends MapScriptService with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource, event: Event): Event = {
    logger.debug(s"Executing map script for StatusWebhookEventSource ${connection.getName}")
    val inputParams = buildDefaultInputParams(connection)
    inputParams.put("content", event.getProperty("content"))
    runnerScriptService.executeScript[StatusWebhookEvent](
      connection.mapScript,
      inputParams,
      new TypeReference[StatusWebhookEvent] {}
    )
  }
}
